/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginContext {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginContext.class);
    private final RangerPluginConfig config;
    private RangerAuthContext authContext;
    private RangerAuthContextListener authContextListener;
    private RangerAdminClient adminClient;

    public RangerPluginContext(RangerPluginConfig config) {
        this.config = config;
    }

    public RangerPluginConfig getConfig() {
        return this.config;
    }

    public String getClusterName() {
        return this.config.getClusterName();
    }

    public String getClusterType() {
        return this.config.getClusterType();
    }

    public RangerAuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(RangerAuthContext authContext) {
        this.authContext = authContext;
    }

    public void setAuthContextListener(RangerAuthContextListener authContextListener) {
        this.authContextListener = authContextListener;
    }

    public void notifyAuthContextChanged() {
        RangerAuthContextListener authContextListener = this.authContextListener;
        if (authContextListener != null) {
            authContextListener.contextChanged();
        }
    }

    public RangerAdminClient getAdminClient() {
        return this.adminClient;
    }

    public void setAdminClient(RangerAdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public RangerAdminClient createAdminClient(RangerPluginConfig pluginConfig) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + ")");
        }
        RangerAdminClient ret = null;
        String propertyName = pluginConfig.getPropertyPrefix() + ".policy.source.impl";
        String policySourceImpl = pluginConfig.get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Value for property[%s] was null or empty. Unexpected! Will use policy source of type[%s]", propertyName, RangerAdminRESTClient.class.getName()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Value for property[%s] was [%s].", propertyName, policySourceImpl));
            }
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error("failed to instantiate policy source of type '" + policySourceImpl + "'. Will use policy source of type '" + RangerAdminRESTClient.class.getName() + "'", (Throwable)excp);
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), pluginConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + "): policySourceImpl=" + policySourceImpl + ", client=" + ret);
        }
        this.setAdminClient(ret);
        return ret;
    }
}

