/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeUtils;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;

public class UpgradeChecker {
    public Pair<Boolean, String> checkDatanodeRunning() {
        String command = "ps aux | grep org.apache.hadoop.ozone.HddsDatanodeService | grep -v grep";
        try {
            Process exec = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", command});
            boolean notTimeout = exec.waitFor(10L, TimeUnit.SECONDS);
            if (!notTimeout) {
                return Pair.of((Object)true, (Object)String.format("Execution of the command '%s' timeout", command));
            }
            if (exec.exitValue() == 0) {
                return Pair.of((Object)true, (Object)"HddsDatanodeService is running. This upgrade command requires datanode to be off and in the IN_MAINTENANCE mode. Please put the datanode in the desired state first, then try this command later again.");
            }
            if (exec.exitValue() == 1) {
                return Pair.of((Object)false, (Object)"HddsDatanodeService is not running.");
            }
            return Pair.of((Object)true, (Object)String.format("Return code of the command '%s' is %d", command, exec.exitValue()));
        }
        catch (IOException | InterruptedException e) {
            return Pair.of((Object)true, (Object)String.format("Run command '%s' has error '%s'", command, e.getMessage()));
        }
    }

    public Pair<HDDSLayoutFeature, HDDSLayoutFeature> getLayoutFeature(DatanodeDetails dnDetail, OzoneConfiguration conf) throws IOException {
        DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage((ConfigurationSource)conf, dnDetail.getUuidString());
        HDDSLayoutVersionManager layoutVersionManager = new HDDSLayoutVersionManager(layoutStorage.getLayoutVersion());
        int metadataLayoutVersion = layoutVersionManager.getMetadataLayoutVersion();
        HDDSLayoutFeature metadataLayoutFeature = (HDDSLayoutFeature)layoutVersionManager.getFeature(metadataLayoutVersion);
        int softwareLayoutVersion = layoutVersionManager.getSoftwareLayoutVersion();
        HDDSLayoutFeature softwareLayoutFeature = (HDDSLayoutFeature)layoutVersionManager.getFeature(softwareLayoutVersion);
        return Pair.of((Object)softwareLayoutFeature, (Object)metadataLayoutFeature);
    }

    public List<HddsVolume> getAllVolume(DatanodeDetails detail, OzoneConfiguration configuration) throws IOException {
        MutableVolumeSet dataVolumeSet = UpgradeUtils.getHddsVolumes(configuration, StorageVolume.VolumeType.DATA_VOLUME, detail.getUuidString());
        return StorageVolumeUtil.getHddsVolumesList((List)dataVolumeSet.getVolumesList());
    }

    public static boolean isAlreadyUpgraded(HddsVolume hddsVolume) {
        File migrateFile = UpgradeUtils.getVolumeUpgradeCompleteFile(hddsVolume);
        return migrateFile.exists();
    }
}

