/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.recon.schema;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="ozone.recon.sql.db")
public class ReconSqlDbConfig {
    @Config(key="driver", type=ConfigType.STRING, defaultValue="org.apache.derby.jdbc.EmbeddedDriver", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Recon SQL DB driver class. Defaults to Derby.")
    private String driverClass;
    @Config(key="jdbc.url", type=ConfigType.STRING, defaultValue="jdbc:derby:${ozone.recon.db.dir}/ozone_recon_derby.db", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Ozone Recon SQL database jdbc url.")
    private String jdbcUrl;
    @Config(key="username", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Ozone Recon SQL database username.")
    private String username;
    @Config(key="password", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Ozone Recon SQL database password.")
    private String password;
    @Config(key="auto.commit", type=ConfigType.BOOLEAN, defaultValue="true", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Sets the Ozone Recon database connection property of auto-commit to true/false.")
    private boolean autoCommit;
    @Config(key="conn.timeout", type=ConfigType.TIME, defaultValue="30000ms", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Sets time in milliseconds before call to getConnection is timed out.")
    private long connectionTimeout;
    @Config(key="conn.max.active", type=ConfigType.INT, defaultValue="5", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="The max active connections to the SQL database.")
    private int maxActiveConnections;
    @Config(key="conn.max.age", type=ConfigType.TIME, timeUnit=TimeUnit.SECONDS, defaultValue="1800s", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Sets maximum time a connection can be active in seconds.")
    private long connectionMaxAge;
    @Config(key="conn.idle.max.age", type=ConfigType.TIME, timeUnit=TimeUnit.SECONDS, defaultValue="3600s", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Sets maximum time to live for idle connection in seconds.")
    private long connectionIdleMaxAge;
    @Config(key="conn.idle.test.period", type=ConfigType.TIME, timeUnit=TimeUnit.SECONDS, defaultValue="60s", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Sets maximum time to live for idle connection in seconds.")
    private long connectionIdleTestPeriod;
    @Config(key="conn.idle.test", type=ConfigType.STRING, defaultValue="SELECT 1", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="The query to send to the DB to maintain keep-alives and test for dead connections.")
    private String idleTestQuery;
    @Config(key="jooq.dialect", type=ConfigType.STRING, defaultValue="DERBY", tags={ConfigTag.STORAGE, ConfigTag.RECON, ConfigTag.OZONE}, description="Recon internally uses Jooq to talk to its SQL DB. By default, we support Derby and Sqlite out of the box. Please refer to https://www.jooq.org/javadoc/latest/org.jooq/org/jooq/SQLDialect.html to specify different dialect.")
    private String sqlDbDialect;

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxActiveConnections() {
        return this.maxActiveConnections;
    }

    public void setMaxActiveConnections(int maxActiveConnections) {
        this.maxActiveConnections = maxActiveConnections;
    }

    public long getConnectionMaxAge() {
        return this.connectionMaxAge;
    }

    public void setConnectionMaxAge(long connectionMaxAge) {
        this.connectionMaxAge = connectionMaxAge;
    }

    public long getConnectionIdleMaxAge() {
        return this.connectionIdleMaxAge;
    }

    public void setConnectionIdleMaxAge(long connectionIdleMaxAge) {
        this.connectionIdleMaxAge = connectionIdleMaxAge;
    }

    public long getConnectionIdleTestPeriod() {
        return this.connectionIdleTestPeriod;
    }

    public void setConnectionIdleTestPeriod(long connectionIdleTestPeriod) {
        this.connectionIdleTestPeriod = connectionIdleTestPeriod;
    }

    public String getIdleTestQuery() {
        return this.idleTestQuery;
    }

    public void setIdleTestQuery(String idleTestQuery) {
        this.idleTestQuery = idleTestQuery;
    }

    public String getSqlDbDialect() {
        return this.sqlDbDialect;
    }

    public void setSqlDbDialect(String sqlDbDialect) {
        this.sqlDbDialect = sqlDbDialect;
    }
}

