/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;

public final class OmMultipartAbortInfo {
    private final String multipartKey;
    private final String multipartOpenKey;
    private final OmMultipartKeyInfo omMultipartKeyInfo;
    private final BucketLayout bucketLayout;

    private OmMultipartAbortInfo(String multipartKey, String multipartOpenKey, OmMultipartKeyInfo omMultipartKeyInfo, BucketLayout bucketLayout) {
        this.multipartKey = multipartKey;
        this.multipartOpenKey = multipartOpenKey;
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.bucketLayout = bucketLayout;
    }

    public String getMultipartKey() {
        return this.multipartKey;
    }

    public String getMultipartOpenKey() {
        return this.multipartOpenKey;
    }

    public OmMultipartKeyInfo getOmMultipartKeyInfo() {
        return this.omMultipartKeyInfo;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OmMultipartAbortInfo that = (OmMultipartAbortInfo)other;
        return this.multipartKey.equals(that.multipartKey) && this.multipartOpenKey.equals(that.multipartOpenKey) && this.bucketLayout.equals((Object)that.bucketLayout) && this.omMultipartKeyInfo.equals(that.omMultipartKeyInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multipartKey, this.multipartOpenKey, this.bucketLayout, this.omMultipartKeyInfo});
    }

    public static class Builder {
        private String multipartKey;
        private String multipartOpenKey;
        private OmMultipartKeyInfo omMultipartKeyInfo;
        private BucketLayout bucketLayout;

        public Builder setMultipartKey(String mpuKey) {
            this.multipartKey = mpuKey;
            return this;
        }

        public Builder setMultipartOpenKey(String mpuOpenKey) {
            this.multipartOpenKey = mpuOpenKey;
            return this;
        }

        public Builder setMultipartKeyInfo(OmMultipartKeyInfo multipartKeyInfo) {
            this.omMultipartKeyInfo = multipartKeyInfo;
            return this;
        }

        public Builder setBucketLayout(BucketLayout layout) {
            this.bucketLayout = layout;
            return this;
        }

        public OmMultipartAbortInfo build() {
            return new OmMultipartAbortInfo(this.multipartKey, this.multipartOpenKey, this.omMultipartKeyInfo, this.bucketLayout);
        }
    }
}

