/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;

public abstract class AbstractReplicationTask {
    private volatile Status status = Status.QUEUED;
    private final long containerId;
    private final Instant queued;
    private final long deadlineMsSinceEpoch;
    private final long term;
    private StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority priority = StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority.NORMAL;
    private boolean shouldOnlyRunOnInServiceDatanodes = true;

    protected AbstractReplicationTask(long containerID, long deadlineMsSinceEpoch, long term) {
        this(containerID, deadlineMsSinceEpoch, term, Clock.system(ZoneId.systemDefault()));
    }

    protected AbstractReplicationTask(long containerID, long deadlineMsSinceEpoch, long term, Clock clock) {
        this.containerId = containerID;
        this.deadlineMsSinceEpoch = deadlineMsSinceEpoch;
        this.term = term;
        this.queued = Instant.now(clock);
    }

    protected abstract String getMetricName();

    protected abstract String getMetricDescriptionSegment();

    public long getContainerId() {
        return this.containerId;
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status newStatus) {
        this.status = newStatus;
    }

    public Instant getQueued() {
        return this.queued;
    }

    public long getTerm() {
        return this.term;
    }

    public long getDeadline() {
        return this.deadlineMsSinceEpoch;
    }

    public abstract void runTask();

    public void setPriority(StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority priority) {
        this.priority = priority;
    }

    public StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority getPriority() {
        return this.priority;
    }

    public boolean shouldOnlyRunOnInServiceDatanodes() {
        return this.shouldOnlyRunOnInServiceDatanodes;
    }

    protected void setShouldOnlyRunOnInServiceDatanodes(boolean runOnInServiceOnly) {
        this.shouldOnlyRunOnInServiceDatanodes = runOnInServiceOnly;
    }

    protected Object getCommandForDebug() {
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append((Object)this.getStatus()).append(" ").append(this.getCommandForDebug());
        if (this.getStatus() == Status.QUEUED) {
            sb.append(", queued at ").append(this.getQueued());
        }
        return sb.toString();
    }

    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        FAILED,
        DONE,
        SKIPPED;

    }
}

