/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;

public class DatanodeTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private final Table<KEY, VALUE> table;

    public DatanodeTable(Table<KEY, VALUE> table) {
        this.table = table;
    }

    public void put(KEY key, VALUE value) throws IOException {
        this.table.put(key, value);
    }

    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws IOException {
        this.table.putWithBatch(batch, key, value);
    }

    public boolean isEmpty() throws IOException {
        return this.table.isEmpty();
    }

    public void delete(KEY key) throws IOException {
        this.table.delete(key);
    }

    public void deleteRange(KEY beginKey, KEY endKey) throws IOException {
        this.table.deleteRange(beginKey, endKey);
    }

    public void deleteWithBatch(BatchOperation batch, KEY key) throws IOException {
        this.table.deleteWithBatch(batch, key);
    }

    public final TableIterator<KEY, ? extends Table.KeyValue<KEY, VALUE>> iterator() {
        throw new UnsupportedOperationException("Iterating tables directly is not supported for datanode containers due to differing schema version.");
    }

    public final TableIterator<KEY, ? extends Table.KeyValue<KEY, VALUE>> iterator(KEY prefix) {
        throw new UnsupportedOperationException("Iterating tables directly is not supported for datanode containers due to differing schema version.");
    }

    public String getName() throws IOException {
        return this.table.getName();
    }

    public long getEstimatedKeyCount() throws IOException {
        return this.table.getEstimatedKeyCount();
    }

    public boolean isExist(KEY key) throws IOException {
        return this.table.isExist(key);
    }

    public VALUE get(KEY key) throws IOException {
        return (VALUE)this.table.get(key);
    }

    public VALUE getIfExist(KEY key) throws IOException {
        return (VALUE)this.table.getIfExist(key);
    }

    public VALUE getReadCopy(KEY key) throws IOException {
        return (VALUE)this.table.getReadCopy(key);
    }

    public List<? extends Table.KeyValue<KEY, VALUE>> getRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.table.getRangeKVs(startKey, count, prefix, filters);
    }

    public List<? extends Table.KeyValue<KEY, VALUE>> getSequentialRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.table.getSequentialRangeKVs(startKey, count, prefix, filters);
    }

    public void deleteBatchWithPrefix(BatchOperation batch, KEY prefix) throws IOException {
        this.table.deleteBatchWithPrefix(batch, prefix);
    }

    public void dumpToFileWithPrefix(File externalFile, KEY prefix) throws IOException {
        this.table.dumpToFileWithPrefix(externalFile, prefix);
    }

    public void loadFromFile(File externalFile) throws IOException {
        this.table.loadFromFile(externalFile);
    }

    public void close() throws Exception {
        this.table.close();
    }
}

