/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.FixedLengthStringCodec;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCompactRangeOptions;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreWithIncrementalChunkList;
import org.apache.hadoop.ozone.container.metadata.DeleteTransactionStore;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.LiveFileMetaData;

public class DatanodeStoreSchemaThreeImpl
extends DatanodeStoreWithIncrementalChunkList
implements DeleteTransactionStore<String> {
    public static final String DUMP_FILE_SUFFIX = ".data";
    public static final String DUMP_DIR = "db";
    private final Table<String, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deleteTransactionTable = ((DatanodeSchemaThreeDBDefinition)this.getDbDef()).getDeleteTransactionsColumnFamily().getTable(this.getStore());

    public DatanodeStoreSchemaThreeImpl(ConfigurationSource config, String dbPath, boolean openReadOnly) throws IOException {
        super(config, new DatanodeSchemaThreeDBDefinition(dbPath, config), openReadOnly);
    }

    @Override
    public Table<String, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeleteTransactionTable() {
        return this.deleteTransactionTable;
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator(long containerID) throws IOException {
        return new AbstractDatanodeStore.KeyValueBlockIterator(containerID, (TableIterator<String, ? extends Table.KeyValue<String, BlockData>>)this.getBlockDataTableWithIterator().iterator((Object)DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID)), new MetadataKeyFilters.KeyPrefixFilter().addFilter(DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID) + "#", true));
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator(long containerID, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        return new AbstractDatanodeStore.KeyValueBlockIterator(containerID, (TableIterator<String, ? extends Table.KeyValue<String, BlockData>>)this.getBlockDataTableWithIterator().iterator((Object)DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID)), filter);
    }

    @Override
    public BlockIterator<Long> getFinalizeBlockIterator(long containerID, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        return new AbstractDatanodeStore.KeyValueBlockLocalIdIterator(containerID, (TableIterator<String, ? extends Table.KeyValue<String, Long>>)this.getFinalizeBlocksTableWithIterator().iterator((Object)DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID)), filter);
    }

    public void removeKVContainerData(long containerID) throws IOException {
        String prefix = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID);
        try (BatchOperation batch = this.getBatchHandler().initBatchOperation();){
            this.getMetadataTable().deleteBatchWithPrefix(batch, (Object)prefix);
            this.getBlockDataTable().deleteBatchWithPrefix(batch, (Object)prefix);
            if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.HBASE_SUPPORT)) {
                this.getLastChunkInfoTable().deleteBatchWithPrefix(batch, (Object)prefix);
            }
            this.getDeleteTransactionTable().deleteBatchWithPrefix(batch, (Object)prefix);
            this.getBatchHandler().commitBatchOperation(batch);
        }
    }

    public void dumpKVContainerData(long containerID, File dumpDir) throws IOException {
        String prefix = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix(containerID);
        this.getMetadataTable().dumpToFileWithPrefix(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getMetadataTable(), dumpDir), (Object)prefix);
        this.getBlockDataTable().dumpToFileWithPrefix(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getBlockDataTable(), dumpDir), (Object)prefix);
        if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.HBASE_SUPPORT)) {
            this.getLastChunkInfoTable().dumpToFileWithPrefix(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getLastChunkInfoTable(), dumpDir), (Object)prefix);
        }
        this.getDeleteTransactionTable().dumpToFileWithPrefix(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getDeleteTransactionTable(), dumpDir), (Object)prefix);
    }

    public void loadKVContainerData(File dumpDir) throws IOException {
        this.getMetadataTable().loadFromFile(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getMetadataTable(), dumpDir));
        this.getBlockDataTable().loadFromFile(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getBlockDataTable(), dumpDir));
        if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.HBASE_SUPPORT)) {
            this.getLastChunkInfoTable().loadFromFile(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getLastChunkInfoTable(), dumpDir));
        }
        this.getDeleteTransactionTable().loadFromFile(DatanodeStoreSchemaThreeImpl.getTableDumpFile(this.getDeleteTransactionTable(), dumpDir));
    }

    public static File getTableDumpFile(Table<String, ?> table, File dumpDir) throws IOException {
        return new File(dumpDir, table.getName() + DUMP_FILE_SUFFIX);
    }

    public static File getDumpDir(File metaDir) {
        return new File(metaDir, DUMP_DIR);
    }

    @Override
    public void compactionIfNeeded() throws Exception {
        RocksDatabase rocksDB = ((RDBStore)this.getStore()).getDb();
        List liveFileMetaDataList = rocksDB.getLiveFilesMetaData();
        DatanodeConfiguration df = (DatanodeConfiguration)((Object)((AbstractDatanodeDBDefinition)this.getDbDef()).getConfig().getObject(DatanodeConfiguration.class));
        int numThreshold = df.getAutoCompactionSmallSstFileNum();
        long sizeThreshold = df.getAutoCompactionSmallSstFileSize();
        HashMap<String, Map> stat = new HashMap<String, Map>();
        for (LiveFileMetaData liveFileMetaData : liveFileMetaDataList) {
            if (liveFileMetaData.size() >= sizeThreshold) continue;
            String cf = StringUtils.bytes2String((byte[])liveFileMetaData.columnFamilyName());
            stat.computeIfAbsent(cf, k -> new HashMap());
            stat.computeIfPresent(cf, (k, v) -> {
                v.computeIfAbsent(file.level(), l -> new LinkedList());
                v.computeIfPresent(file.level(), (k1, v1) -> {
                    v1.add(file);
                    return v1;
                });
                return v;
            });
        }
        for (Map.Entry entry : stat.entrySet()) {
            for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                if (((List)innerEntry.getValue()).size() <= numThreshold) continue;
                RocksDatabase.ColumnFamily columnFamily = null;
                for (RocksDatabase.ColumnFamily cf : rocksDB.getExtraColumnFamilies()) {
                    if (!cf.getName().equals(entry.getKey())) continue;
                    columnFamily = cf;
                    break;
                }
                if (columnFamily != null) {
                    long startCId = Long.MAX_VALUE;
                    long endCId = Long.MIN_VALUE;
                    for (LiveFileMetaData file : (List)innerEntry.getValue()) {
                        long firstCId = DatanodeSchemaThreeDBDefinition.getContainerId(FixedLengthStringCodec.bytes2String((byte[])file.smallestKey()));
                        long lastCId = DatanodeSchemaThreeDBDefinition.getContainerId(FixedLengthStringCodec.bytes2String((byte[])file.largestKey()));
                        startCId = Math.min(firstCId, startCId);
                        endCId = Math.max(lastCId, endCId);
                    }
                    ManagedCompactRangeOptions options = new ManagedCompactRangeOptions();
                    options.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
                    LOG.info("CF {} level {} small file number {} exceeds threshold {}. Auto compact small sst files.", new Object[]{entry.getKey(), innerEntry.getKey(), ((List)innerEntry.getValue()).size(), numThreshold});
                    rocksDB.compactRange(columnFamily, DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixBytes(startCId), DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixBytes(endCId + 1L), options);
                    continue;
                }
                LOG.warn("Failed to find cf {} in DB {}", entry.getKey(), ((AbstractDatanodeDBDefinition)this.getDbDef()).getClass());
            }
        }
    }
}

