/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.ECBlockOutputStream;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.ContainerTokenIdentifier;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactoryImpl;
import org.apache.hadoop.ozone.client.io.ECBlockInputStreamProxy;
import org.apache.hadoop.ozone.client.io.ECBlockReconstructedStripeInputStream;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECContainerOperationClient;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionMetrics;
import org.apache.hadoop.ozone.container.ec.reconstruction.TokenHelper;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.util.MemoizedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECReconstructionCoordinator
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(ECReconstructionCoordinator.class);
    private static final int EC_RECONSTRUCT_STRIPE_READ_POOL_MIN_SIZE = 3;
    private static final int EC_RECONSTRUCT_STRIPE_WRITE_POOL_MIN_SIZE = 5;
    private final ECContainerOperationClient containerOperationClient;
    private final ByteBufferPool byteBufferPool;
    private final ExecutorService ecReconstructReadExecutor;
    private final MemoizedSupplier<ExecutorService> ecReconstructWriteExecutor;
    private final BlockInputStreamFactory blockInputStreamFactory;
    private final TokenHelper tokenHelper;
    private final ContainerClientMetrics clientMetrics;
    private final ECReconstructionMetrics metrics;
    private final StateContext context;
    private final OzoneClientConfig ozoneClientConfig;

    public ECReconstructionCoordinator(ConfigurationSource conf, CertificateClient certificateClient, SecretKeySignerClient secretKeyClient, StateContext context, ECReconstructionMetrics metrics, String threadNamePrefix) throws IOException {
        this.context = context;
        this.containerOperationClient = new ECContainerOperationClient(conf, certificateClient);
        this.byteBufferPool = new ElasticByteBufferPool();
        this.ozoneClientConfig = (OzoneClientConfig)conf.getObject(OzoneClientConfig.class);
        this.ecReconstructReadExecutor = ECReconstructionCoordinator.createThreadPoolExecutor(3, this.ozoneClientConfig.getEcReconstructStripeReadPoolLimit(), threadNamePrefix + "ec-reconstruct-reader-TID-%d");
        this.ecReconstructWriteExecutor = MemoizedSupplier.valueOf(() -> ECReconstructionCoordinator.createThreadPoolExecutor(5, this.ozoneClientConfig.getEcReconstructStripeWritePoolLimit(), threadNamePrefix + "ec-reconstruct-writer-TID-%d"));
        this.blockInputStreamFactory = BlockInputStreamFactoryImpl.getInstance((ByteBufferPool)this.byteBufferPool, () -> this.ecReconstructReadExecutor);
        this.tokenHelper = new TokenHelper(new SecurityConfig(conf), secretKeyClient);
        this.clientMetrics = ContainerClientMetrics.acquire();
        this.metrics = metrics;
    }

    public void reconstructECContainerGroup(long containerID, ECReplicationConfig repConfig, SortedMap<Integer, DatanodeDetails> sourceNodeMap, SortedMap<Integer, DatanodeDetails> targetNodeMap) throws IOException {
        Pipeline pipeline = this.rebuildInputPipeline(repConfig, sourceNodeMap);
        SortedMap<Long, BlockData[]> blockDataMap = this.getBlockDataMap(containerID, repConfig, sourceNodeMap);
        SortedMap<Long, BlockLocationInfo> blockLocationInfoMap = this.calcBlockLocationInfoMap(containerID, blockDataMap, pipeline);
        ContainerID cid = ContainerID.valueOf((long)containerID);
        String containerToken = TokenHelper.encode(this.tokenHelper.getContainerToken(cid));
        ArrayList<DatanodeDetails> recoveringContainersCreatedDNs = new ArrayList<DatanodeDetails>();
        try {
            for (Map.Entry<Integer, DatanodeDetails> entry : targetNodeMap.entrySet()) {
                DatanodeDetails dn = entry.getValue();
                int index = entry.getKey();
                LOG.debug("Creating container {} on datanode {} for index {}", new Object[]{containerID, dn, index});
                this.containerOperationClient.createRecoveringContainer(containerID, dn, repConfig, containerToken, index);
                recoveringContainersCreatedDNs.add(dn);
            }
            for (Map.Entry<Number, Object> entry : blockLocationInfoMap.entrySet()) {
                Long key = (Long)entry.getKey();
                BlockLocationInfo blockLocationInfo = (BlockLocationInfo)entry.getValue();
                this.reconstructECBlockGroup(blockLocationInfo, repConfig, targetNodeMap, (BlockData[])blockDataMap.get(key));
            }
            for (DatanodeDetails datanodeDetails : recoveringContainersCreatedDNs) {
                LOG.debug("Closing container {} on datanode {}", (Object)containerID, (Object)datanodeDetails);
                this.containerOperationClient.closeContainer(containerID, datanodeDetails, repConfig, containerToken);
            }
            this.metrics.incReconstructionTotal();
            this.metrics.incBlockGroupReconstructionTotal(blockLocationInfoMap.size());
        }
        catch (Exception e) {
            this.metrics.incReconstructionFailsTotal();
            this.metrics.incBlockGroupReconstructionFailsTotal(blockLocationInfoMap.size());
            LOG.warn("Exception while reconstructing the container {}. Cleaning up all the recovering containers in the reconstruction process.", (Object)containerID, (Object)e);
            for (DatanodeDetails dn : recoveringContainersCreatedDNs) {
                try {
                    this.containerOperationClient.deleteContainerInState(containerID, dn, repConfig, containerToken, (Set<ContainerProtos.ContainerDataProto.State>)ImmutableSet.of((Object)ContainerProtos.ContainerDataProto.State.UNHEALTHY, (Object)ContainerProtos.ContainerDataProto.State.RECOVERING));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Deleted the container {}, at the target: {}", (Object)containerID, (Object)dn);
                }
                catch (IOException ioe) {
                    LOG.error("Exception while deleting the container {} at target: {}", new Object[]{containerID, dn, ioe});
                }
            }
            throw e;
        }
    }

    private ECBlockOutputStream getECBlockOutputStream(BlockLocationInfo blockLocationInfo, DatanodeDetails datanodeDetails, ECReplicationConfig repConfig, int replicaIndex) throws IOException {
        StreamBufferArgs streamBufferArgs = StreamBufferArgs.getDefaultStreamBufferArgs((ReplicationConfig)repConfig, (OzoneClientConfig)this.ozoneClientConfig);
        return new ECBlockOutputStream(blockLocationInfo.getBlockID(), (XceiverClientFactory)this.containerOperationClient.getXceiverClientManager(), this.containerOperationClient.singleNodePipeline(datanodeDetails, repConfig, replicaIndex), BufferPool.empty(), this.ozoneClientConfig, blockLocationInfo.getToken(), this.clientMetrics, streamBufferArgs, this.ecReconstructWriteExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void reconstructECBlockGroup(BlockLocationInfo blockLocationInfo, ECReplicationConfig repConfig, SortedMap<Integer, DatanodeDetails> targetMap, BlockData[] blockDataGroup) throws IOException {
        long safeBlockGroupLength = blockLocationInfo.getLength();
        ArrayList<Integer> missingContainerIndexes = new ArrayList<Integer>(targetMap.keySet());
        int dataLocs = ECBlockInputStreamProxy.expectedDataLocations((ECReplicationConfig)repConfig, (long)safeBlockGroupLength);
        ArrayList<Integer> toReconstructIndexes = new ArrayList<Integer>();
        ArrayList<Integer> notReconstructIndexes = new ArrayList<Integer>();
        for (Integer index : missingContainerIndexes) {
            if (index <= dataLocs || index > repConfig.getData()) {
                toReconstructIndexes.add(index);
                continue;
            }
            notReconstructIndexes.add(index);
        }
        OzoneClientConfig clientConfig = this.ozoneClientConfig;
        clientConfig.setChecksumVerify(true);
        try (ECBlockReconstructedStripeInputStream sis = new ECBlockReconstructedStripeInputStream(repConfig, blockLocationInfo, (XceiverClientFactory)this.containerOperationClient.getXceiverClientManager(), null, this.blockInputStreamFactory, this.byteBufferPool, this.ecReconstructReadExecutor, clientConfig);){
            ECBlockOutputStream[] targetBlockStreams = new ECBlockOutputStream[toReconstructIndexes.size()];
            ECBlockOutputStream[] emptyBlockStreams = new ECBlockOutputStream[notReconstructIndexes.size()];
            ByteBuffer[] bufs = new ByteBuffer[toReconstructIndexes.size()];
            try {
                DatanodeDetails datanodeDetails;
                int replicaIndex;
                int i2;
                for (i2 = 0; i2 < toReconstructIndexes.size(); ++i2) {
                    replicaIndex = (Integer)toReconstructIndexes.get(i2);
                    datanodeDetails = (DatanodeDetails)targetMap.get(replicaIndex);
                    targetBlockStreams[i2] = this.getECBlockOutputStream(blockLocationInfo, datanodeDetails, repConfig, replicaIndex);
                    bufs[i2] = this.byteBufferPool.getBuffer(false, repConfig.getEcChunkSize());
                    bufs[i2].clear();
                }
                for (i2 = 0; i2 < notReconstructIndexes.size(); ++i2) {
                    replicaIndex = (Integer)notReconstructIndexes.get(i2);
                    datanodeDetails = (DatanodeDetails)targetMap.get(replicaIndex);
                    emptyBlockStreams[i2] = this.getECBlockOutputStream(blockLocationInfo, datanodeDetails, repConfig, replicaIndex);
                }
                if (!toReconstructIndexes.isEmpty()) {
                    int readLen;
                    sis.setRecoveryIndexes((Collection)toReconstructIndexes.stream().map(i -> i - 1).collect(Collectors.toSet()));
                    for (long length = safeBlockGroupLength; length > 0L; length -= (long)readLen) {
                        try {
                            readLen = sis.recoverChunks(bufs);
                            Set failedIndexes = sis.getFailedIndexes();
                            if (!failedIndexes.isEmpty()) {
                                this.logBlockGroupDetails(blockLocationInfo, repConfig, blockDataGroup);
                            }
                        }
                        catch (IOException e) {
                            this.logBlockGroupDetails(blockLocationInfo, repConfig, blockDataGroup);
                            throw e;
                        }
                        for (int i3 = 0; i3 < bufs.length; ++i3) {
                            if (bufs[i3].remaining() != 0) {
                                CompletableFuture future = targetBlockStreams[i3].write(bufs[i3]);
                                this.checkFailures(targetBlockStreams[i3], future);
                            }
                            bufs[i3].clear();
                        }
                    }
                }
                ArrayList<ECBlockOutputStream> allStreams = new ArrayList<ECBlockOutputStream>(Arrays.asList(targetBlockStreams));
                allStreams.addAll(Arrays.asList(emptyBlockStreams));
                for (ECBlockOutputStream targetStream : allStreams) {
                    targetStream.executePutBlock(true, true, blockLocationInfo.getLength(), blockDataGroup);
                    this.checkFailures(targetStream, targetStream.getCurrentPutBlkResponseFuture());
                }
            }
            finally {
                for (ByteBuffer buf : bufs) {
                    this.byteBufferPool.putBuffer(buf);
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])targetBlockStreams);
                IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])emptyBlockStreams);
            }
        }
    }

    private void logBlockGroupDetails(BlockLocationInfo blockLocationInfo, ECReplicationConfig repConfig, BlockData[] blockDataGroup) {
        LOG.info("Block group details for {}. Replication Config {}. Calculated safe length: {}. ", new Object[]{blockLocationInfo.getBlockID(), repConfig, blockLocationInfo.getLength()});
        for (int i = 0; i < blockDataGroup.length; ++i) {
            BlockData data = blockDataGroup[i];
            if (data == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Block Data for: ").append(data.getBlockID()).append(" replica Index: ").append(i + 1).append(" block length: ").append(data.getSize()).append(" block group length: ").append(data.getBlockGroupLength()).append(" chunk list: \n");
            int cnt = 0;
            for (ContainerProtos.ChunkInfo chunkInfo : data.getChunks()) {
                if (cnt > 0) {
                    sb.append("\n");
                }
                sb.append("  chunkNum: ").append(++cnt).append(" length: ").append(chunkInfo.getLen()).append(" offset: ").append(chunkInfo.getOffset());
            }
            LOG.info(sb.toString());
        }
    }

    private void checkFailures(ECBlockOutputStream targetBlockStream, CompletableFuture<ContainerProtos.ContainerCommandResponseProto> currentPutBlkResponseFuture) throws IOException {
        if (this.isFailed(targetBlockStream, currentPutBlkResponseFuture)) {
            throw new IOException("Chunk write failed at the new target node: " + targetBlockStream.getDatanodeDetails() + ". Aborting the reconstruction process.", targetBlockStream.getIoException());
        }
    }

    private boolean isFailed(ECBlockOutputStream outputStream, CompletableFuture<ContainerProtos.ContainerCommandResponseProto> chunkWriteResponseFuture) {
        if (chunkWriteResponseFuture == null) {
            return true;
        }
        ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = null;
        try {
            containerCommandResponseProto = chunkWriteResponseFuture.get();
        }
        catch (InterruptedException e) {
            outputStream.setIoException((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            outputStream.setIoException((Throwable)e);
        }
        if (outputStream.getIoException() != null) {
            return true;
        }
        return containerCommandResponseProto == null;
    }

    SortedMap<Long, BlockLocationInfo> calcBlockLocationInfoMap(long containerID, SortedMap<Long, BlockData[]> blockDataMap, Pipeline pipeline) {
        TreeMap<Long, BlockLocationInfo> blockInfoMap = new TreeMap<Long, BlockLocationInfo>();
        for (Map.Entry<Long, BlockData[]> entry : blockDataMap.entrySet()) {
            Long localID = entry.getKey();
            BlockData[] blockGroup = entry.getValue();
            long blockGroupLen = this.calcEffectiveBlockGroupLen(blockGroup, pipeline.getReplicationConfig().getRequiredNodes());
            if (blockGroupLen <= 0L) continue;
            BlockID blockID = new BlockID(containerID, localID.longValue());
            BlockLocationInfo blockLocationInfo = new BlockLocationInfo.Builder().setBlockID(blockID).setLength(blockGroupLen).setPipeline(pipeline).setToken(this.tokenHelper.getBlockToken(blockID, blockGroupLen)).build();
            blockInfoMap.put(localID, blockLocationInfo);
        }
        return blockInfoMap;
    }

    @Override
    public void close() throws IOException {
        if (this.containerOperationClient != null) {
            this.containerOperationClient.close();
        }
        if (this.ecReconstructWriteExecutor.isInitialized()) {
            ((ExecutorService)this.ecReconstructWriteExecutor.get()).shutdownNow();
        }
    }

    private Pipeline rebuildInputPipeline(ECReplicationConfig repConfig, SortedMap<Integer, DatanodeDetails> sourceNodeMap) {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>(sourceNodeMap.values());
        HashMap<DatanodeDetails, Integer> dnVsIndex = new HashMap<DatanodeDetails, Integer>();
        for (Map.Entry<Integer, DatanodeDetails> next : sourceNodeMap.entrySet()) {
            Integer key = next.getKey();
            DatanodeDetails value = next.getValue();
            dnVsIndex.put(value, key);
        }
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setReplicationConfig((ReplicationConfig)repConfig).setNodes(nodes).setReplicaIndexes(dnVsIndex).setState(Pipeline.PipelineState.CLOSED).build();
    }

    private SortedMap<Long, BlockData[]> getBlockDataMap(long containerID, ECReplicationConfig repConfig, Map<Integer, DatanodeDetails> sourceNodeMap) throws IOException {
        TreeMap<Long, BlockData[]> resultMap = new TreeMap<Long, BlockData[]>();
        Token<ContainerTokenIdentifier> containerToken = this.tokenHelper.getContainerToken(ContainerID.valueOf((long)containerID));
        for (Map.Entry<Integer, DatanodeDetails> next : sourceNodeMap.entrySet()) {
            BlockData[] blockDataArr;
            Integer index = next.getKey();
            DatanodeDetails dn = next.getValue();
            for (BlockData blockData : blockDataArr = this.containerOperationClient.listBlock(containerID, dn, repConfig, containerToken)) {
                BlockID blockID = blockData.getBlockID();
                BlockData[] blkDataArr = resultMap.getOrDefault(blockData.getLocalID(), new BlockData[repConfig.getRequiredNodes()]);
                blkDataArr[index.intValue() - 1] = blockData;
                resultMap.put(blockID.getLocalID(), blkDataArr);
            }
        }
        Iterator resultIterator = resultMap.entrySet().iterator();
        block2: while (resultIterator.hasNext()) {
            Map.Entry entry = resultIterator.next();
            BlockData[] blockDataArr = (BlockData[])entry.getValue();
            for (Map.Entry<Integer, DatanodeDetails> e : sourceNodeMap.entrySet()) {
                if (blockDataArr[e.getKey() - 1] != null) continue;
                LOG.warn("In container {} block {} does not have a putBlock entry for index {} on datanode {} making it an orphan block / stripe. It will not be reconstructed", new Object[]{containerID, entry.getKey(), e.getKey(), e.getValue()});
                resultIterator.remove();
                continue block2;
            }
        }
        return resultMap;
    }

    private long calcEffectiveBlockGroupLen(BlockData[] blockGroup, int replicaCount) {
        Preconditions.checkState((blockGroup.length == replicaCount ? 1 : 0) != 0);
        long blockGroupLen = Long.MAX_VALUE;
        for (int i = 0; i < replicaCount; ++i) {
            if (blockGroup[i] == null) continue;
            long putBlockLen = blockGroup[i].getBlockGroupLength();
            blockGroupLen = Math.min(putBlockLen, blockGroupLen);
        }
        return blockGroupLen == Long.MAX_VALUE ? 0L : blockGroupLen;
    }

    public ECReconstructionMetrics getECReconstructionMetrics() {
        return this.metrics;
    }

    OptionalLong getTermOfLeaderSCM() {
        return Optional.ofNullable(this.context).map(StateContext::getTermOfLeaderSCM).orElse(OptionalLong.empty());
    }

    private static ExecutorService createThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String threadNameFormat) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

