/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.DatanodeVersion;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.DatanodeRatisServerConfig;
import org.apache.hadoop.hdds.conf.RatisConfUtils;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.RatisServerConfiguration;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TraditionalBinaryPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerRatis
implements XceiverServerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverServerRatis.class);
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private static final List<Integer> DEFAULT_PRIORITY_LIST = new ArrayList<Integer>(Collections.nCopies(3, 0));
    private int serverPort;
    private int adminPort;
    private int clientPort;
    private int dataStreamPort;
    private final RaftServer server;
    private final String name;
    private final List<ThreadPoolExecutor> chunkExecutors;
    private final ContainerDispatcher dispatcher;
    private final ContainerController containerController;
    private final ClientId clientId = ClientId.randomId();
    private final StateContext context;
    private boolean isStarted = false;
    private final DatanodeDetails datanodeDetails;
    private final ConfigurationSource conf;
    private final ConcurrentMap<RaftGroupId, ActivePipelineContext> activePipelines = new ConcurrentHashMap<RaftGroupId, ActivePipelineContext>();
    private final long requestTimeout;
    private final boolean shouldDeleteRatisLogDirectory;
    private final boolean streamEnable;
    private final DatanodeRatisServerConfig ratisServerConfig;
    private final HddsDatanodeService datanodeService;

    private static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private XceiverServerRatis(HddsDatanodeService hddsDatanodeService, DatanodeDetails dd, ContainerDispatcher dispatcher, ContainerController containerController, StateContext context, ConfigurationSource conf, Parameters parameters) throws IOException {
        this.conf = conf;
        Objects.requireNonNull(dd, "DatanodeDetails == null");
        this.datanodeService = hddsDatanodeService;
        this.datanodeDetails = dd;
        this.ratisServerConfig = (DatanodeRatisServerConfig)conf.getObject(DatanodeRatisServerConfig.class);
        this.assignPorts();
        this.streamEnable = conf.getBoolean("hdds.container.ratis.datastream.enabled", false);
        this.context = context;
        this.dispatcher = dispatcher;
        this.containerController = containerController;
        String threadNamePrefix = this.datanodeDetails.threadNamePrefix();
        this.chunkExecutors = XceiverServerRatis.createChunkExecutors(conf, threadNamePrefix);
        this.shouldDeleteRatisLogDirectory = this.ratisServerConfig.shouldDeleteRatisLogDirectory();
        RaftProperties serverProperties = this.newRaftProperties();
        RaftPeerId raftPeerId = RatisHelper.toRaftPeerId((DatanodeDetails)dd);
        this.name = this.getClass().getSimpleName() + "(" + raftPeerId + ")";
        this.server = RaftServer.newBuilder().setServerId(raftPeerId).setProperties(serverProperties).setStateMachineRegistry(this::getStateMachine).setParameters(parameters).setOption(RaftStorage.StartupOption.RECOVER).build();
        this.requestTimeout = conf.getTimeDuration("hdds.datanode.ratis.server.request.timeout", "2m", TimeUnit.MILLISECONDS);
    }

    private void assignPorts() {
        this.clientPort = this.determinePort("hdds.container.ratis.ipc.port", 9858);
        if (DatanodeVersion.fromProtoValue((int)this.datanodeDetails.getInitialVersion()).compareTo((Enum)DatanodeVersion.SEPARATE_RATIS_PORTS_AVAILABLE) >= 0) {
            this.adminPort = this.determinePort("hdds.container.ratis.admin.port", 9857);
            this.serverPort = this.determinePort("hdds.container.ratis.server.port", 9856);
        } else {
            this.adminPort = this.clientPort;
            this.serverPort = this.clientPort;
        }
    }

    private int determinePort(String key, int defaultValue) {
        boolean randomPort = this.conf.getBoolean("hdds.container.ratis.ipc.random.port", false);
        return randomPort ? 0 : this.conf.getInt(key, defaultValue);
    }

    private ContainerStateMachine getStateMachine(RaftGroupId gid) {
        return new ContainerStateMachine(this.datanodeService, gid, this.dispatcher, this.containerController, this.chunkExecutors, this, this.conf, this.datanodeDetails.threadNamePrefix());
    }

    private void setUpRatisStream(RaftProperties properties) {
        this.dataStreamPort = this.conf.getBoolean("hdds.container.ratis.datastream.random.port", false) ? 0 : this.conf.getInt("hdds.container.ratis.datastream.port", 9855);
        RatisHelper.enableNettyStreaming((RaftProperties)properties);
        NettyConfigKeys.DataStream.setPort((RaftProperties)properties, (int)this.dataStreamPort);
        int dataStreamAsyncRequestThreadPoolSize = this.ratisServerConfig.getStreamRequestThreads();
        RaftServerConfigKeys.DataStream.setAsyncRequestThreadPoolSize((RaftProperties)properties, (int)dataStreamAsyncRequestThreadPoolSize);
        int dataStreamClientPoolSize = this.ratisServerConfig.getClientPoolSize();
        RaftServerConfigKeys.DataStream.setClientPoolSize((RaftProperties)properties, (int)dataStreamClientPoolSize);
    }

    public RaftProperties newRaftProperties() {
        RaftProperties properties = new RaftProperties();
        RpcType rpc = this.setRpcType(properties);
        int logAppenderBufferByteLimit = this.setRaftSegmentAndWriteBufferSize(properties);
        int max = Math.max(0x2000000, logAppenderBufferByteLimit);
        RatisConfUtils.Grpc.setMessageSizeMax((RaftProperties)properties, (int)max);
        this.setRaftSegmentPreallocatedSize(properties);
        if (this.streamEnable) {
            this.setUpRatisStream(properties);
        }
        this.setStateMachineDataConfigurations(properties);
        this.setTimeoutForRetryCache(properties);
        this.setRatisLeaderElectionTimeout(properties);
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)this.ratisServerConfig.isPreVoteEnabled());
        Collection storageDirPaths = HddsServerUtil.getOzoneDatanodeRatisDirectory((ConfigurationSource)this.conf);
        ArrayList storageDirs = new ArrayList(storageDirPaths.size());
        storageDirPaths.forEach(d -> storageDirs.add(new File((String)d)));
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, storageDirs);
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Admin.setPort((RaftProperties)properties, (int)this.adminPort);
            GrpcConfigKeys.Client.setPort((RaftProperties)properties, (int)this.clientPort);
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.serverPort);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.serverPort);
        }
        long snapshotThreshold = this.conf.getLong("hdds.ratis.snapshot.threshold", 100000L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)snapshotThreshold);
        this.setPendingRequestsLimits(properties);
        int logQueueNumElements = this.conf.getInt("hdds.container.ratis.log.queue.num-elements", 1024);
        long logQueueByteLimit = (long)this.conf.getStorageSize("hdds.container.ratis.log.queue.byte-limit", "4GB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setQueueElementLimit((RaftProperties)properties, (int)logQueueNumElements);
        RaftServerConfigKeys.Log.setQueueByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logQueueByteLimit));
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)false);
        int purgeGap = this.conf.getInt("hdds.container.ratis.log.purge.gap", 1000000);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)purgeGap);
        RatisServerConfiguration ratisServerConfiguration = (RatisServerConfiguration)this.conf.getObject(RatisServerConfiguration.class);
        int numSnapshotsRetained = ratisServerConfiguration.getNumSnapshotsRetained();
        RaftServerConfigKeys.Snapshot.setRetentionFileNum((RaftProperties)properties, (int)numSnapshotsRetained);
        RatisHelper.createRaftServerProperties((ConfigurationSource)this.conf, (RaftProperties)properties);
        return properties;
    }

    private void setRatisLeaderElectionTimeout(RaftProperties properties) {
        TimeUnit leaderElectionMinTimeoutUnit = OzoneConfigKeys.HDDS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("hdds.ratis.leader.election.minimum.timeout.duration", OzoneConfigKeys.HDDS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getDuration(), leaderElectionMinTimeoutUnit);
        TimeDuration leaderElectionMinTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)leaderElectionMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)leaderElectionMinTimeout);
        long leaderElectionMaxTimeout = leaderElectionMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)leaderElectionMaxTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private void setTimeoutForRetryCache(RaftProperties properties) {
        TimeUnit timeUnit = OzoneConfigKeys.HDDS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("hdds.ratis.server.retry-cache.timeout.duration", OzoneConfigKeys.HDDS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
    }

    private void setRaftSegmentPreallocatedSize(RaftProperties properties) {
        long raftSegmentPreallocatedSize = (long)this.conf.getStorageSize("hdds.container.ratis.segment.preallocated.size", "4MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
    }

    private int setRaftSegmentAndWriteBufferSize(RaftProperties properties) {
        long raftSegmentSize;
        int logAppenderQueueNumElements = this.conf.getInt("hdds.container.ratis.log.appender.queue.num-elements", 1024);
        int logAppenderQueueByteLimit = (int)this.conf.getStorageSize("hdds.container.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        long raftSegmentBufferSize = logAppenderQueueByteLimit + 8;
        Preconditions.assertTrue((raftSegmentBufferSize <= (raftSegmentSize = (long)this.conf.getStorageSize("hdds.container.ratis.segment.size", "64MB", StorageUnit.BYTES)) ? 1 : 0) != 0, () -> "hdds.container.ratis.log.appender.queue.byte-limit = " + logAppenderQueueByteLimit + " must be <= (" + "hdds.container.ratis.segment.size" + " - 8 = " + (raftSegmentSize - 8L) + ")");
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentBufferSize));
        return logAppenderQueueByteLimit;
    }

    private void setStateMachineDataConfigurations(RaftProperties properties) {
        RaftServerConfigKeys.Log.StateMachineData.setSync((RaftProperties)properties, (boolean)true);
        TimeUnit timeUnit = OzoneConfigKeys.HDDS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("hdds.container.ratis.statemachinedata.sync.timeout", OzoneConfigKeys.HDDS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getDuration(), timeUnit);
        TimeDuration dataSyncTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeout((RaftProperties)properties, (TimeDuration)dataSyncTimeout);
        int syncTimeoutRetryDefault = (int)this.ratisServerConfig.getFollowerSlownessTimeout() / dataSyncTimeout.toIntExact(TimeUnit.MILLISECONDS);
        int numSyncRetries = this.conf.getInt("hdds.container.ratis.statemachinedata.sync.retries", syncTimeoutRetryDefault);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeoutRetry((RaftProperties)properties, (int)numSyncRetries);
        RaftServerConfigKeys.Log.StateMachineData.setCachingEnabled((RaftProperties)properties, (boolean)true);
    }

    private RpcType setRpcType(RaftProperties properties) {
        String rpcType = this.conf.get("hdds.container.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)rpcType);
        RatisHelper.setRpcType((RaftProperties)properties, (RpcType)rpc);
        return rpc;
    }

    private void setPendingRequestsLimits(RaftProperties properties) {
        long pendingRequestsBytesLimit = (long)this.conf.getStorageSize("hdds.container.ratis.leader.pending.bytes.limit", "1GB", StorageUnit.BYTES);
        int pendingRequestsMegaBytesLimit = HddsUtils.roundupMb((long)pendingRequestsBytesLimit);
        RaftServerConfigKeys.Write.setByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)pendingRequestsMegaBytesLimit, (TraditionalBinaryPrefix)TraditionalBinaryPrefix.MEGA));
    }

    public static XceiverServerRatis newXceiverServerRatis(HddsDatanodeService hddsDatanodeService, DatanodeDetails datanodeDetails, ConfigurationSource ozoneConf, ContainerDispatcher dispatcher, ContainerController containerController, CertificateClient caClient, StateContext context) throws IOException {
        Parameters parameters = XceiverServerRatis.createTlsParameters(new SecurityConfig(ozoneConf), caClient);
        return new XceiverServerRatis(hddsDatanodeService, datanodeDetails, dispatcher, containerController, context, ozoneConf, parameters);
    }

    private static Parameters createTlsParameters(SecurityConfig conf, CertificateClient caClient) throws IOException {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            GrpcTlsConfig serverConfig = new GrpcTlsConfig((KeyManager)caClient.getKeyManager(), (TrustManager)caClient.getTrustManager(), true);
            GrpcTlsConfig clientConfig = new GrpcTlsConfig((KeyManager)caClient.getKeyManager(), (TrustManager)caClient.getTrustManager(), false);
            return RatisHelper.setServerTlsConf((GrpcTlsConfig)serverConfig, (GrpcTlsConfig)clientConfig);
        }
        return null;
    }

    @Override
    public void start() throws IOException {
        if (!this.isStarted) {
            LOG.info("Starting {}", (Object)this.name);
            for (ThreadPoolExecutor executor : this.chunkExecutors) {
                executor.prestartAllCoreThreads();
            }
            this.server.start();
            RaftServerRpc serverRpc = this.server.getServerRpc();
            this.clientPort = this.getRealPort(serverRpc.getClientServerAddress(), DatanodeDetails.Port.Name.RATIS);
            this.adminPort = this.getRealPort(serverRpc.getAdminServerAddress(), DatanodeDetails.Port.Name.RATIS_ADMIN);
            this.serverPort = this.getRealPort(serverRpc.getInetSocketAddress(), DatanodeDetails.Port.Name.RATIS_SERVER);
            if (this.streamEnable) {
                DataStreamServerRpc dataStreamServerRpc = this.server.getDataStreamServerRpc();
                this.dataStreamPort = this.getRealPort(dataStreamServerRpc.getInetSocketAddress(), DatanodeDetails.Port.Name.RATIS_DATASTREAM);
            }
            this.isStarted = true;
        }
    }

    private int getRealPort(InetSocketAddress address, DatanodeDetails.Port.Name portName) {
        int realPort = address.getPort();
        DatanodeDetails.Port port = DatanodeDetails.newPort((DatanodeDetails.Port.Name)portName, (Integer)realPort);
        this.datanodeDetails.setPort(port);
        LOG.info("{} is started using port {}", (Object)this.name, (Object)port);
        return realPort;
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            try {
                LOG.info("Closing {}", (Object)this.name);
                this.server.close();
                for (ExecutorService executorService : this.chunkExecutors) {
                    executorService.shutdown();
                }
                this.isStarted = false;
            }
            catch (IOException e) {
                LOG.error("Failed to close {}.", (Object)this.name, (Object)e);
            }
        }
    }

    @Override
    public int getIPCPort() {
        return this.clientPort;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    public RaftServer.Division getServerDivision() throws IOException {
        return this.getServerDivision((RaftGroupId)this.server.getGroupIds().iterator().next());
    }

    public RaftServer.Division getServerDivision(RaftGroupId id) throws IOException {
        return this.server.getDivision(id);
    }

    public boolean getShouldDeleteRatisLogDirectory() {
        return this.shouldDeleteRatisLogDirectory;
    }

    private void processReply(RaftClientReply reply) throws IOException {
        NotLeaderException notLeaderException = reply.getNotLeaderException();
        if (notLeaderException != null) {
            throw notLeaderException;
        }
        StateMachineException stateMachineException = reply.getStateMachineException();
        if (stateMachineException != null) {
            throw stateMachineException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        Span span = TracingUtil.importAndCreateSpan((String)("XceiverServerRatis." + request.getCmdType().name()), (String)request.getTraceID());
        try (Scope ignored = GlobalTracer.get().activateSpan(span);){
            RaftClientReply reply;
            RaftClientRequest raftClientRequest = this.createRaftClientRequest(request, pipelineID, RaftClientRequest.writeRequestType());
            try {
                reply = (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get(this.requestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e.getMessage(), e);
            }
            this.processReply(reply);
        }
        finally {
            span.finish();
        }
    }

    private RaftClientRequest createRaftClientRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID, RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(this.server.getId()).setGroupId(RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID).getId())).setCallId(XceiverServerRatis.nextCallId()).setMessage((Message)ContainerCommandRequestMessage.toMessage((ContainerProtos.ContainerCommandRequestProto)request, null)).setType(type).build();
    }

    private GroupInfoRequest createGroupInfoRequest(HddsProtos.PipelineID pipelineID) {
        return new GroupInfoRequest(this.clientId, this.server.getId(), RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID).getId()), XceiverServerRatis.nextCallId());
    }

    private void handlePipelineFailure(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto, String reason) {
        RaftPeerId raftPeerId = RaftPeerId.valueOf((ByteString)roleInfoProto.getSelf().getId());
        Preconditions.assertEquals((Object)this.getServer().getId(), (Object)raftPeerId, (String)"raftPeerId");
        StringBuilder b = new StringBuilder().append(this.name).append(" with datanodeId ").append(RatisHelper.toDatanodeId((RaftPeerId)raftPeerId)).append("handlePipelineFailure ").append(" for ").append(reason).append(": ").append(roleInfoProto.getRole()).append(" elapsed time=").append(roleInfoProto.getRoleElapsedTimeMs()).append("ms");
        switch (roleInfoProto.getRole()) {
            case CANDIDATE: {
                long lastLeaderElapsedTime = roleInfoProto.getCandidateInfo().getLastLeaderElapsedTimeMs();
                b.append(", lastLeaderElapsedTime=").append(lastLeaderElapsedTime).append("ms");
                break;
            }
            case FOLLOWER: {
                b.append(", outstandingOp=").append(roleInfoProto.getFollowerInfo().getOutstandingOp());
                break;
            }
            case LEADER: {
                long followerSlownessTimeoutMs = this.ratisServerConfig.getFollowerSlownessTimeout();
                for (RaftProtos.ServerRpcProto follower : roleInfoProto.getLeaderInfo().getFollowerInfoList()) {
                    long lastRpcElapsedTimeMs = follower.getLastRpcElapsedTimeMs();
                    boolean slow = lastRpcElapsedTimeMs > followerSlownessTimeoutMs;
                    RaftPeerId followerId = RaftPeerId.valueOf((ByteString)follower.getId().getId());
                    b.append("\n  Follower ").append(followerId).append(" with datanodeId ").append(RatisHelper.toDatanodeId((RaftPeerId)followerId)).append(" is ").append(slow ? "slow" : " responding").append(" with lastRpcElapsedTime=").append(lastRpcElapsedTimeMs).append("ms");
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected role " + roleInfoProto.getRole());
            }
        }
        this.triggerPipelineClose(groupId, b.toString(), StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED);
    }

    private void triggerPipelineClose(RaftGroupId groupId, String detail, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason reasonCode) {
        PipelineID pipelineID = PipelineID.valueOf((UUID)groupId.getUuid());
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Builder closePipelineInfo = StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(pipelineID.getProtobuf()).setReason(reasonCode).setDetailedReason(detail);
        StorageContainerDatanodeProtocolProtos.PipelineAction action = StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(closePipelineInfo).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build();
        if (this.context != null) {
            this.context.addPipelineActionIfAbsent(action);
            if (!((ActivePipelineContext)this.activePipelines.get(groupId)).isPendingClose()) {
                this.context.getParent().triggerHeartbeat();
                this.activePipelines.computeIfPresent(groupId, (key, value) -> new ActivePipelineContext(value.isPipelineLeader(), true));
            }
        }
        LOG.error("pipeline Action {} on pipeline {}.Reason : {}", new Object[]{action.getAction(), pipelineID, action.getClosePipeline().getDetailedReason()});
    }

    @Override
    public boolean isExist(HddsProtos.PipelineID pipelineId) {
        return this.activePipelines.containsKey(RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId).getId()));
    }

    private long calculatePipelineBytesWritten(HddsProtos.PipelineID pipelineID) {
        long bytesWritten = 0L;
        for (Container<?> container : this.containerController.getContainers()) {
            Object containerData = container.getContainerData();
            if (((ContainerData)containerData).getOriginPipelineId().compareTo(pipelineID.getId()) != 0) continue;
            bytesWritten += ((ContainerData)containerData).getWriteBytes();
        }
        return bytesWritten;
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        try {
            Iterable gids = this.server.getGroupIds();
            ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport> reports = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport>();
            for (RaftGroupId groupId : gids) {
                HddsProtos.PipelineID pipelineID = PipelineID.valueOf((UUID)groupId.getUuid()).getProtobuf();
                boolean isLeader = this.activePipelines.getOrDefault(groupId, new ActivePipelineContext(false, false)).isPipelineLeader();
                reports.add(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(pipelineID).setIsLeader(isLeader).setBytesWritten(this.calculatePipelineBytesWritten(pipelineID)).build());
            }
            return reports;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addGroup(HddsProtos.PipelineID pipelineId, List<DatanodeDetails> peers) throws IOException {
        if (peers.size() == XceiverServerRatis.getDefaultPriorityList().size()) {
            this.addGroup(pipelineId, peers, XceiverServerRatis.getDefaultPriorityList());
        } else {
            this.addGroup(pipelineId, peers, new ArrayList<Integer>(Collections.nCopies(peers.size(), 0)));
        }
    }

    @Override
    public void addGroup(HddsProtos.PipelineID pipelineId, List<DatanodeDetails> peers, List<Integer> priorityList) throws IOException {
        RaftClientReply reply;
        PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId);
        RaftGroupId groupId = RaftGroupId.valueOf((UUID)pipelineID.getId());
        RaftGroup group = RatisHelper.newRaftGroup((RaftGroupId)groupId, peers, priorityList);
        GroupManagementRequest request = GroupManagementRequest.newAdd((ClientId)this.clientId, (RaftPeerId)this.server.getId(), (long)XceiverServerRatis.nextCallId(), (RaftGroup)group);
        LOG.debug("Received addGroup request for pipeline {}", (Object)pipelineID);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
        LOG.info("Created group {}", (Object)pipelineID);
    }

    @Override
    public void removeGroup(HddsProtos.PipelineID pipelineId) throws IOException {
        RaftClientReply reply;
        GroupManagementRequest request = GroupManagementRequest.newRemove((ClientId)this.clientId, (RaftPeerId)this.server.getId(), (long)XceiverServerRatis.nextCallId(), (RaftGroupId)RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId).getId()), (boolean)this.shouldDeleteRatisLogDirectory, (!this.shouldDeleteRatisLogDirectory ? 1 : 0) != 0);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    void handleFollowerSlowness(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto, RaftPeer follower) {
        this.handlePipelineFailure(groupId, roleInfoProto, "slow follower " + follower.getId());
    }

    void handleNoLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(groupId, roleInfoProto, "no leader");
    }

    void handleApplyTransactionFailure(RaftGroupId groupId, RaftProtos.RaftPeerRole role) {
        UUID dnId = RatisHelper.toDatanodeId((RaftPeerId)this.getServer().getId());
        String msg = "Ratis Transaction failure in datanode " + dnId + " with role " + role + " .Triggering pipeline close action.";
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.STATEMACHINE_TRANSACTION_FAILED);
    }

    void handleInstallSnapshotFromLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        LOG.warn("handleInstallSnapshotFromLeader for firstTermIndexInLog={}, terminating pipeline: {}", (Object)firstTermIndexInLog, (Object)groupId);
        this.handlePipelineFailure(groupId, roleInfoProto, "install snapshot notification");
    }

    @VisibleForTesting
    public void handleNodeLogFailure(RaftGroupId groupId, Throwable t) {
        String msg = t == null ? "Unspecified failure reported in Ratis log" : t.getMessage();
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_LOG_FAILED);
    }

    public long getMinReplicatedIndex(PipelineID pipelineID) throws IOException {
        GroupInfoReply reply = this.getServer().getGroupInfo(this.createGroupInfoRequest(pipelineID.getProtobuf()));
        Long minIndex = RatisHelper.getMinReplicatedIndex((Collection)reply.getCommitInfos());
        return minIndex == null ? -1L : minIndex;
    }

    public Collection<RaftPeer> getRaftPeersInPipeline(PipelineID pipelineId) throws IOException {
        RaftGroupId groupId = RaftGroupId.valueOf((UUID)pipelineId.getId());
        return this.server.getDivision(groupId).getGroup().getPeers();
    }

    public void notifyGroupRemove(RaftGroupId gid) {
        this.activePipelines.remove(gid);
    }

    void notifyGroupAdd(RaftGroupId gid) {
        this.activePipelines.put(gid, new ActivePipelineContext(false, false));
        this.sendPipelineReport();
    }

    void handleLeaderChangedNotification(RaftGroupMemberId groupMemberId, RaftPeerId raftPeerId1) {
        LOG.info("Leader change notification received for group: {} with new leaderId: {}", (Object)groupMemberId.getGroupId(), (Object)raftPeerId1);
        boolean leaderForGroup = this.server.getId().equals((Object)raftPeerId1);
        this.activePipelines.compute(groupMemberId.getGroupId(), (key, value) -> value == null ? new ActivePipelineContext(leaderForGroup, false) : new ActivePipelineContext(leaderForGroup, value.isPendingClose()));
        if (this.context != null && leaderForGroup) {
            this.sendPipelineReport();
        }
    }

    private void sendPipelineReport() {
        if (this.context != null) {
            this.context.addIncrementalReport((com.google.protobuf.Message)this.context.getParent().getContainer().getPipelineReport());
            this.context.getParent().triggerHeartbeat();
        }
    }

    private static List<ThreadPoolExecutor> createChunkExecutors(ConfigurationSource conf, String threadNamePrefix) {
        int threadCountPerDisk = conf.getInt("hdds.container.ratis.num.write.chunk.threads.per.volume", 10);
        int numberOfDisks = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)conf).size();
        Object[] executors = new ThreadPoolExecutor[threadCountPerDisk * numberOfDisks];
        for (int i = 0; i < executors.length; ++i) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "ChunkWriter-" + i + "-%d").build();
            LinkedBlockingDeque<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
            executors[i] = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, workQueue, threadFactory);
        }
        return ImmutableList.copyOf((Object[])executors);
    }

    public static List<Integer> getDefaultPriorityList() {
        return DEFAULT_PRIORITY_LIST;
    }

    private static class ActivePipelineContext {
        private final boolean isPipelineLeader;
        private final boolean isPendingClose;

        ActivePipelineContext(boolean isPipelineLeader, boolean isPendingClose) {
            this.isPipelineLeader = isPipelineLeader;
            this.isPendingClose = isPendingClose;
        }

        public boolean isPipelineLeader() {
            return this.isPipelineLeader;
        }

        public boolean isPendingClose() {
            return this.isPendingClose;
        }
    }
}

