/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.time.Clock;
import java.util.OptionalLong;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteContainerCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteContainerCommandHandler.class);
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private final AtomicInteger timeoutCount = new AtomicInteger(0);
    private final ThreadPoolExecutor executor;
    private final Clock clock;
    private int maxQueueSize;
    private final MutableRate opsLatencyMs;

    public DeleteContainerCommandHandler(int threadPoolSize, Clock clock, int queueSize, String threadNamePrefix) {
        this(clock, new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "DeleteContainerThread-%d").build()), queueSize);
    }

    protected DeleteContainerCommandHandler(Clock clock, ThreadPoolExecutor executor, int queueSize) {
        this.executor = executor;
        this.clock = clock;
        this.maxQueueSize = queueSize;
        MetricsRegistry registry = new MetricsRegistry(DeleteContainerCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand + "Ms");
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        DeleteContainerCommand deleteContainerCommand = (DeleteContainerCommand)command;
        ContainerController controller = ozoneContainer.getController();
        try {
            this.executor.execute(() -> this.handleInternal(command, context, deleteContainerCommand, controller));
        }
        catch (RejectedExecutionException ex) {
            LOG.warn("Delete Container command is received for container {} is ignored as command queue reach max size {}.", (Object)deleteContainerCommand.getContainerID(), (Object)this.maxQueueSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInternal(SCMCommand<?> command, StateContext context, DeleteContainerCommand deleteContainerCommand, ContainerController controller) {
        long startTime = Time.monotonicNow();
        this.invocationCount.incrementAndGet();
        try {
            if (command.hasExpired(this.clock.millis())) {
                LOG.info("Not processing the delete container command for container {} as the current time {}ms is after the command deadline {}ms", new Object[]{deleteContainerCommand.getContainerID(), this.clock.millis(), command.getDeadline()});
                this.timeoutCount.incrementAndGet();
                return;
            }
            if (context != null) {
                OptionalLong currentTerm = context.getTermOfLeaderSCM();
                long cmdTerm = command.getTerm();
                if (currentTerm.isPresent() && cmdTerm < currentTerm.getAsLong()) {
                    LOG.info("Ignoring delete container command for container {} since SCM leader has new term ({} < {})", new Object[]{deleteContainerCommand.getContainerID(), cmdTerm, currentTerm.getAsLong()});
                    return;
                }
            }
            controller.deleteContainer(deleteContainerCommand.getContainerID(), deleteContainerCommand.isForce());
        }
        catch (IOException e) {
            LOG.error("Exception occurred while deleting the container.", (Throwable)e);
        }
        finally {
            this.opsLatencyMs.add(Time.monotonicNow() - startTime);
        }
    }

    @Override
    public int getQueuedCount() {
        return this.executor.getQueue().size();
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount.get();
    }

    public int getTimeoutCount() {
        return this.timeoutCount.get();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getThreadPoolMaxPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getThreadPoolActivePoolSize() {
        return this.executor.getActiveCount();
    }

    @Override
    public void stop() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

