/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.server.YamlUtils;
import org.apache.hadoop.hdds.upgrade.BelongsToHDDSLayoutVersion;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class DatanodeIdYaml {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeIdYaml.class);

    private DatanodeIdYaml() {
    }

    public static void createDatanodeIdFile(DatanodeDetails datanodeDetails, File path, ConfigurationSource conf) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        Yaml yaml = new Yaml(options);
        DatanodeDetailsYaml data = DatanodeIdYaml.getDatanodeDetailsYaml(datanodeDetails, conf);
        YamlUtils.dump((Yaml)yaml, (Object)data, (File)path, (Logger)LOG);
    }

    public static DatanodeDetails readDatanodeIdFile(File path) throws IOException {
        DatanodeDetails datanodeDetails;
        try (InputStream inputFileStream = Files.newInputStream(path.toPath(), new OpenOption[0]);){
            DatanodeDetailsYaml datanodeDetailsYaml;
            try {
                datanodeDetailsYaml = (DatanodeDetailsYaml)YamlUtils.loadAs((InputStream)inputFileStream, DatanodeDetailsYaml.class);
            }
            catch (Exception e) {
                throw new IOException("Unable to parse yaml file.", e);
            }
            DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
            builder.setUuid(UUID.fromString(datanodeDetailsYaml.getUuid())).setIpAddress(datanodeDetailsYaml.getIpAddress()).setHostName(datanodeDetailsYaml.getHostName()).setCertSerialId(datanodeDetailsYaml.getCertSerialId());
            if (datanodeDetailsYaml.getPersistedOpState() != null) {
                builder.setPersistedOpState(HddsProtos.NodeOperationalState.valueOf((String)datanodeDetailsYaml.getPersistedOpState()));
            }
            builder.setPersistedOpStateExpiry(datanodeDetailsYaml.getPersistedOpStateExpiryEpochSec());
            if (!MapUtils.isEmpty(datanodeDetailsYaml.getPortDetails())) {
                for (Map.Entry<String, Integer> portEntry : datanodeDetailsYaml.getPortDetails().entrySet()) {
                    builder.addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.valueOf((String)portEntry.getKey()), (Integer)portEntry.getValue()));
                }
            }
            builder.setInitialVersion(datanodeDetailsYaml.getInitialVersion()).setCurrentVersion(datanodeDetailsYaml.getCurrentVersion());
            datanodeDetails = builder.build();
        }
        return datanodeDetails;
    }

    private static DatanodeDetailsYaml getDatanodeDetailsYaml(DatanodeDetails datanodeDetails, ConfigurationSource conf) throws IOException {
        DatanodeLayoutStorage datanodeLayoutStorage = new DatanodeLayoutStorage(conf, datanodeDetails.getUuidString());
        LinkedHashMap<String, Integer> portDetails = new LinkedHashMap<String, Integer>();
        List ports = datanodeDetails.getPorts();
        if (!CollectionUtils.isEmpty((Collection)ports)) {
            for (DatanodeDetails.Port port : ports) {
                HDDSLayoutFeature layoutFeature;
                Field f = null;
                try {
                    f = DatanodeDetails.Port.Name.class.getDeclaredField(port.getName().name());
                }
                catch (NoSuchFieldException e) {
                    LOG.error("There is no such field as {} in {}", (Object)port.getName().name(), DatanodeDetails.Port.Name.class);
                }
                if (f != null && f.isAnnotationPresent(BelongsToHDDSLayoutVersion.class) && (layoutFeature = f.getAnnotation(BelongsToHDDSLayoutVersion.class).value()).layoutVersion() > datanodeLayoutStorage.getLayoutVersion()) continue;
                portDetails.put(port.getName().toString(), port.getValue());
            }
        }
        String persistedOpString = null;
        if (datanodeDetails.getPersistedOpState() != null) {
            persistedOpString = datanodeDetails.getPersistedOpState().name();
        }
        return new DatanodeDetailsYaml(datanodeDetails.getUuidString(), datanodeDetails.getIpAddress(), datanodeDetails.getHostName(), datanodeDetails.getCertSerialId(), persistedOpString, datanodeDetails.getPersistedOpStateExpiryEpochSec(), portDetails, datanodeDetails.getInitialVersion(), datanodeDetails.getCurrentVersion());
    }

    public static class DatanodeDetailsYaml {
        private String uuid;
        private String ipAddress;
        private String hostName;
        private String certSerialId;
        private String persistedOpState;
        private long persistedOpStateExpiryEpochSec = 0L;
        private Map<String, Integer> portDetails;
        private int initialVersion;
        private int currentVersion;

        public DatanodeDetailsYaml() {
        }

        private DatanodeDetailsYaml(String uuid, String ipAddress, String hostName, String certSerialId, String persistedOpState, long persistedOpStateExpiryEpochSec, Map<String, Integer> portDetails, int initialVersion, int currentVersion) {
            this.uuid = uuid;
            this.ipAddress = ipAddress;
            this.hostName = hostName;
            this.certSerialId = certSerialId;
            this.persistedOpState = persistedOpState;
            this.persistedOpStateExpiryEpochSec = persistedOpStateExpiryEpochSec;
            this.portDetails = portDetails;
            this.initialVersion = initialVersion;
            this.currentVersion = currentVersion;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getCertSerialId() {
            return this.certSerialId;
        }

        public String getPersistedOpState() {
            return this.persistedOpState;
        }

        public long getPersistedOpStateExpiryEpochSec() {
            return this.persistedOpStateExpiryEpochSec;
        }

        public Map<String, Integer> getPortDetails() {
            return this.portDetails;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public void setCertSerialId(String certSerialId) {
            this.certSerialId = certSerialId;
        }

        public void setPersistedOpState(String persistedOpState) {
            this.persistedOpState = persistedOpState;
        }

        public void setPersistedOpStateExpiryEpochSec(long opStateExpiryEpochSec) {
            this.persistedOpStateExpiryEpochSec = opStateExpiryEpochSec;
        }

        public void setPortDetails(Map<String, Integer> portDetails) {
            this.portDetails = portDetails;
        }

        public int getInitialVersion() {
            return this.initialVersion;
        }

        public void setInitialVersion(int version) {
            this.initialVersion = version;
        }

        public int getCurrentVersion() {
            return this.currentVersion;
        }

        public void setCurrentVersion(int version) {
            this.currentVersion = version;
        }

        public String toString() {
            return "DatanodeDetailsYaml(" + this.uuid + ", " + this.hostName + "/" + this.ipAddress + ")";
        }
    }
}

