/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.AbstractDataStreamOutput;
import org.apache.hadoop.hdds.scm.storage.BlockDataStreamOutput;
import org.apache.hadoop.ozone.client.io.BlockDataStreamOutputEntry;
import org.apache.hadoop.ozone.client.io.BlockDataStreamOutputEntryPool;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDataStreamOutput
extends AbstractDataStreamOutput
implements KeyMetadataAware {
    private OzoneClientConfig config;
    public static final Logger LOG = LoggerFactory.getLogger(KeyDataStreamOutput.class);
    private boolean closed;
    private long offset;
    private long writeOffset;
    private final BlockDataStreamOutputEntryPool blockDataStreamOutputEntryPool;
    private long clientID;
    private boolean atomicKeyCreation;

    @VisibleForTesting
    public List<BlockDataStreamOutputEntry> getStreamEntries() {
        return this.blockDataStreamOutputEntryPool.getStreamEntries();
    }

    @VisibleForTesting
    public XceiverClientFactory getXceiverClientFactory() {
        return this.blockDataStreamOutputEntryPool.getXceiverClientFactory();
    }

    @VisibleForTesting
    public List<OmKeyLocationInfo> getLocationInfoList() {
        return this.blockDataStreamOutputEntryPool.getLocationInfoList();
    }

    @VisibleForTesting
    public long getClientID() {
        return this.clientID;
    }

    public KeyDataStreamOutput(OzoneClientConfig config, OpenKeySession handler, XceiverClientFactory xceiverClientManager, OzoneManagerProtocol omClient, int chunkSize, String requestId, ReplicationConfig replicationConfig, String uploadID, int partNumber, boolean isMultipart, boolean unsafeByteBufferConversion, boolean atomicKeyCreation) {
        super(HddsClientUtils.getRetryPolicyByException((int)config.getMaxRetryCount(), (long)config.getRetryInterval()));
        this.config = config;
        OmKeyInfo info = handler.getKeyInfo();
        this.blockDataStreamOutputEntryPool = new BlockDataStreamOutputEntryPool(config, omClient, replicationConfig, uploadID, partNumber, isMultipart, info, unsafeByteBufferConversion, xceiverClientManager, handler.getId());
        this.writeOffset = 0L;
        this.clientID = handler.getId();
        this.atomicKeyCreation = atomicKeyCreation;
    }

    public void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) throws IOException {
        this.blockDataStreamOutputEntryPool.addPreallocateBlocks(version, openVersion);
    }

    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.checkNotClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        this.handleWrite(b, off, len, false);
        this.writeOffset += (long)len;
    }

    private void handleWrite(ByteBuffer b, int off, long len, boolean retry) throws IOException {
        while (len > 0L) {
            try {
                BlockDataStreamOutputEntry current = this.blockDataStreamOutputEntryPool.allocateBlockIfNeeded();
                int expectedWriteLen = Math.min((int)len, (int)current.getRemaining());
                long currentPos = current.getWrittenDataLength();
                int writtenLength = this.writeToDataStreamOutput(current, retry, len, b, expectedWriteLen, off, currentPos);
                if (current.getRemaining() <= 0L) {
                    this.handleFlushOrClose(StreamAction.FULL);
                }
                len -= (long)writtenLength;
                off += writtenLength;
            }
            catch (Exception e) {
                this.markStreamClosed();
                throw new IOException(e);
            }
        }
    }

    private int writeToDataStreamOutput(BlockDataStreamOutputEntry current, boolean retry, long len, ByteBuffer b, int writeLen, int off, long currentPos) throws IOException {
        try {
            if (retry) {
                current.writeOnRetry(len);
            } else {
                current.write(b, off, writeLen);
                this.offset += (long)writeLen;
            }
        }
        catch (IOException ioe) {
            Preconditions.checkState((!retry || len <= this.config.getStreamBufferMaxSize() ? 1 : 0) != 0);
            int dataWritten = (int)(current.getWrittenDataLength() - currentPos);
            int n = writeLen = retry ? (int)len : dataWritten;
            if (!retry) {
                this.offset += (long)writeLen;
            }
            LOG.debug("writeLen {}, total len {}", (Object)writeLen, (Object)len);
            this.handleException(current, ioe);
        }
        return writeLen;
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        this.checkNotClosed();
        long hsyncPos = this.writeOffset;
        this.handleFlushOrClose(StreamAction.HSYNC);
        Preconditions.checkState((this.offset >= hsyncPos ? 1 : 0) != 0, (String)"offset = %s < hsyncPos = %s", (long)this.offset, (long)hsyncPos);
        this.blockDataStreamOutputEntryPool.hsyncKey(hsyncPos);
    }

    private void handleException(BlockDataStreamOutputEntry streamEntry, IOException exception) throws IOException {
        BlockDataStreamOutputEntry currentStreamEntry;
        Throwable t = HddsClientUtils.checkForException((Exception)exception);
        Preconditions.checkNotNull((Object)t);
        boolean retryFailure = this.checkForRetryFailure(t);
        boolean containerExclusionException = false;
        if (!retryFailure) {
            containerExclusionException = this.checkIfContainerToExclude(t);
        }
        Pipeline pipeline = streamEntry.getPipeline();
        PipelineID pipelineId = pipeline.getId();
        long totalSuccessfulFlushedData = streamEntry.getTotalAckDataLength();
        streamEntry.setCurrentPosition(totalSuccessfulFlushedData);
        long containerId = streamEntry.getBlockID().getContainerID();
        Collection<DatanodeDetails> failedServers = streamEntry.getFailedServers();
        Preconditions.checkNotNull(failedServers);
        if (!containerExclusionException && (currentStreamEntry = this.blockDataStreamOutputEntryPool.getCurrentStreamEntry()) != null) {
            try {
                BlockDataStreamOutput blockDataStreamOutput = (BlockDataStreamOutput)currentStreamEntry.getByteBufStreamOutput();
                blockDataStreamOutput.executePutBlock(false, false);
                blockDataStreamOutput.watchForCommit(false);
            }
            catch (IOException e) {
                LOG.error("Failed to execute putBlock/watchForCommit. Continuing to write chunksin new block", (Throwable)e);
            }
        }
        ExcludeList excludeList = this.blockDataStreamOutputEntryPool.getExcludeList();
        long bufferedDataLen = this.blockDataStreamOutputEntryPool.computeBufferData();
        if (!failedServers.isEmpty()) {
            excludeList.addDatanodes(failedServers);
        }
        if (containerExclusionException) {
            excludeList.addConatinerId(ContainerID.valueOf((long)containerId));
        } else {
            excludeList.addPipeline(pipelineId);
        }
        streamEntry.cleanup(retryFailure);
        if (containerExclusionException) {
            this.blockDataStreamOutputEntryPool.discardPreallocatedBlocks(streamEntry.getBlockID().getContainerID(), null);
        } else {
            this.blockDataStreamOutputEntryPool.discardPreallocatedBlocks(-1L, pipelineId);
        }
        if (bufferedDataLen > 0L) {
            this.handleRetry(exception);
            this.handleWrite(null, 0, bufferedDataLen, true);
            this.resetRetryCount();
        }
    }

    private void markStreamClosed() {
        this.blockDataStreamOutputEntryPool.cleanup();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.checkNotClosed();
        this.handleFlushOrClose(StreamAction.FLUSH);
    }

    private void handleFlushOrClose(StreamAction op) throws IOException {
        if (!this.blockDataStreamOutputEntryPool.isEmpty()) {
            try {
                BlockDataStreamOutputEntry entry;
                while ((entry = this.blockDataStreamOutputEntryPool.getCurrentStreamEntry()) != null) {
                    try {
                        this.handleStreamAction(entry, op);
                        break;
                    }
                    catch (IOException ioe) {
                        this.handleException(entry, ioe);
                    }
                }
                return;
            }
            catch (Exception e) {
                this.markStreamClosed();
                throw e;
            }
        }
    }

    private void handleStreamAction(BlockDataStreamOutputEntry entry, StreamAction op) throws IOException {
        Collection<DatanodeDetails> failedServers = entry.getFailedServers();
        if (!failedServers.isEmpty()) {
            this.blockDataStreamOutputEntryPool.getExcludeList().addDatanodes(failedServers);
        }
        switch (op) {
            case CLOSE: {
                entry.close();
                break;
            }
            case FULL: {
                if (entry.getRemaining() != 0L) break;
                entry.close();
                break;
            }
            case FLUSH: {
                entry.flush();
                break;
            }
            case HSYNC: {
                entry.hsync();
                break;
            }
            default: {
                throw new IOException("Invalid Operation");
            }
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.handleFlushOrClose(StreamAction.CLOSE);
            if (!this.isException()) {
                Preconditions.checkArgument((this.writeOffset == this.offset ? 1 : 0) != 0);
            }
            if (this.atomicKeyCreation) {
                long expectedSize = this.blockDataStreamOutputEntryPool.getDataSize();
                Preconditions.checkArgument((expectedSize == this.offset ? 1 : 0) != 0, (Object)String.format("Expected: %d and actual %d write sizes do not match", expectedSize, this.offset));
            }
            this.blockDataStreamOutputEntryPool.commitKey(this.offset);
        }
        finally {
            this.blockDataStreamOutputEntryPool.cleanup();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.blockDataStreamOutputEntryPool.getCommitUploadPartInfo();
    }

    @VisibleForTesting
    public ExcludeList getExcludeList() {
        return this.blockDataStreamOutputEntryPool.getExcludeList();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.blockDataStreamOutputEntryPool.getMetadata();
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(": Stream is closed! Key: " + this.blockDataStreamOutputEntryPool.getKeyName());
        }
    }

    public static class Builder {
        private OpenKeySession openHandler;
        private XceiverClientFactory xceiverManager;
        private OzoneManagerProtocol omClient;
        private int chunkSize;
        private final String requestID = UUID.randomUUID().toString();
        private String multipartUploadID;
        private int multipartNumber;
        private boolean isMultipartKey;
        private boolean unsafeByteBufferConversion;
        private OzoneClientConfig clientConfig;
        private ReplicationConfig replicationConfig;
        private boolean atomicKeyCreation = false;

        public Builder setMultipartUploadID(String uploadID) {
            this.multipartUploadID = uploadID;
            return this;
        }

        public Builder setMultipartNumber(int partNumber) {
            this.multipartNumber = partNumber;
            return this;
        }

        public Builder setHandler(OpenKeySession handler) {
            this.openHandler = handler;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientFactory manager) {
            this.xceiverManager = manager;
            return this;
        }

        public Builder setOmClient(OzoneManagerProtocol client) {
            this.omClient = client;
            return this;
        }

        public Builder setChunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder setIsMultipartKey(boolean isMultipart) {
            this.isMultipartKey = isMultipart;
            return this;
        }

        public Builder setConfig(OzoneClientConfig config) {
            this.clientConfig = config;
            return this;
        }

        public Builder enableUnsafeByteBufferConversion(boolean enabled) {
            this.unsafeByteBufferConversion = enabled;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder setAtomicKeyCreation(boolean atomicKey) {
            this.atomicKeyCreation = atomicKey;
            return this;
        }

        public KeyDataStreamOutput build() {
            return new KeyDataStreamOutput(this.clientConfig, this.openHandler, this.xceiverManager, this.omClient, this.chunkSize, this.requestID, this.replicationConfig, this.multipartUploadID, this.multipartNumber, this.isMultipartKey, this.unsafeByteBufferConversion, this.atomicKeyCreation);
        }
    }

    static enum StreamAction {
        FLUSH,
        HSYNC,
        CLOSE,
        FULL;

    }
}

