/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;

public class StreamBufferArgs {
    private int streamBufferSize;
    private long streamBufferFlushSize;
    private long streamBufferMaxSize;
    private boolean streamBufferFlushDelay;

    protected StreamBufferArgs(Builder builder) {
        this.streamBufferSize = builder.bufferSize;
        this.streamBufferFlushSize = builder.bufferFlushSize;
        this.streamBufferMaxSize = builder.bufferMaxSize;
        this.streamBufferFlushDelay = builder.streamBufferFlushDelay;
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public long getStreamBufferFlushSize() {
        return this.streamBufferFlushSize;
    }

    public long getStreamBufferMaxSize() {
        return this.streamBufferMaxSize;
    }

    public boolean isStreamBufferFlushDelay() {
        return this.streamBufferFlushDelay;
    }

    public void setStreamBufferFlushDelay(boolean streamBufferFlushDelay) {
        this.streamBufferFlushDelay = streamBufferFlushDelay;
    }

    protected void setStreamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
    }

    protected void setStreamBufferFlushSize(long streamBufferFlushSize) {
        this.streamBufferFlushSize = streamBufferFlushSize;
    }

    protected void setStreamBufferMaxSize(long streamBufferMaxSize) {
        this.streamBufferMaxSize = streamBufferMaxSize;
    }

    public static StreamBufferArgs getDefaultStreamBufferArgs(ReplicationConfig replicationConfig, OzoneClientConfig clientConfig) {
        long bufferMaxSize;
        long flushSize;
        int bufferSize;
        boolean streamBufferFlushDelay = clientConfig.isStreamBufferFlushDelay();
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            bufferSize = ((ECReplicationConfig)replicationConfig).getEcChunkSize();
            flushSize = ((ECReplicationConfig)replicationConfig).getEcChunkSize();
            bufferMaxSize = ((ECReplicationConfig)replicationConfig).getEcChunkSize();
        } else {
            bufferSize = clientConfig.getStreamBufferSize();
            flushSize = clientConfig.getStreamBufferFlushSize();
            bufferMaxSize = clientConfig.getStreamBufferMaxSize();
        }
        return Builder.getNewBuilder().setBufferSize(bufferSize).setBufferFlushSize(flushSize).setBufferMaxSize(bufferMaxSize).setStreamBufferFlushDelay(streamBufferFlushDelay).build();
    }

    public static class Builder {
        private int bufferSize;
        private long bufferFlushSize;
        private long bufferMaxSize;
        private boolean streamBufferFlushDelay;

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBufferFlushSize(long bufferFlushSize) {
            this.bufferFlushSize = bufferFlushSize;
            return this;
        }

        public Builder setBufferMaxSize(long bufferMaxSize) {
            this.bufferMaxSize = bufferMaxSize;
            return this;
        }

        public Builder setStreamBufferFlushDelay(boolean streamBufferFlushDelay) {
            this.streamBufferFlushDelay = streamBufferFlushDelay;
            return this;
        }

        public StreamBufferArgs build() {
            return new StreamBufferArgs(this);
        }

        public static Builder getNewBuilder() {
            return new Builder();
        }
    }
}

