/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceNotFoundException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;

@ThreadSafe
public class AmazonCloudWatchAuditDestination
extends AuditDestination {
    private static Log LOG = LogFactory.getLog(AmazonCloudWatchAuditDestination.class);
    public static final String PROP_LOG_GROUP_NAME = "log_group";
    public static final String PROP_LOG_STREAM_PREFIX = "log_stream_prefix";
    public static final String CONFIG_PREFIX = "ranger.audit.amazon_cloudwatch";
    public static final String PROP_REGION = "region";
    private String logGroupName;
    private String logStreamName;
    private AWSLogs logsClient;
    private String sequenceToken;
    private String regionName;

    @Override
    public void init(Properties props, String propPrefix) {
        LOG.info((Object)"init() called for CloudWatchAuditDestination");
        super.init(props, propPrefix);
        this.logGroupName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_LOG_GROUP_NAME, "ranger_audits");
        this.logStreamName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_LOG_STREAM_PREFIX) + MiscUtil.generateUniqueId();
        this.regionName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_REGION);
        this.logsClient = this.getClient();
        this.createLogStream();
    }

    @Override
    public void stop() {
        super.stop();
        this.logStatus();
    }

    @Override
    public synchronized boolean log(Collection<AuditEventBase> collection) {
        boolean ret = false;
        AWSLogs client = this.getClient();
        PutLogEventsRequest req = new PutLogEventsRequest().withLogEvents(AmazonCloudWatchAuditDestination.toInputLogEvent(collection)).withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName);
        if (StringUtils.isNotBlank((String)this.sequenceToken)) {
            req.setSequenceToken(this.sequenceToken);
        }
        try {
            this.sequenceToken = this.pushLogEvents(req, false, client);
            this.addSuccessCount(collection.size());
            ret = true;
        }
        catch (Throwable e) {
            this.addFailedCount(collection.size());
            LOG.error((Object)"Failed to send audit events", e);
        }
        return ret;
    }

    private String pushLogEvents(PutLogEventsRequest req, boolean retryingOnInvalidSeqToken, AWSLogs client) {
        String sequenceToken;
        try {
            PutLogEventsResult re = client.putLogEvents(req);
            sequenceToken = re.getNextSequenceToken();
        }
        catch (ResourceNotFoundException ex) {
            if (!retryingOnInvalidSeqToken) {
                this.createLogStream();
                return this.pushLogEvents(req, true, client);
            }
            throw ex;
        }
        catch (InvalidSequenceTokenException ex) {
            if (retryingOnInvalidSeqToken) {
                LOG.error((Object)"Unexpected invalid sequence token. Possible race condition occurred");
                throw ex;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Invalid sequence token. Plugin possibly restarted. Updating the sequence token and retrying");
            }
            String sequenceToken2 = ex.getExpectedSequenceToken();
            req.setSequenceToken(sequenceToken2);
            return this.pushLogEvents(req, true, client);
        }
        return sequenceToken;
    }

    @Override
    public void flush() {
    }

    static Collection<InputLogEvent> toInputLogEvent(Collection<AuditEventBase> collection) {
        return collection.stream().map(e -> new InputLogEvent().withMessage(MiscUtil.stringify(e)).withTimestamp(Long.valueOf(e.getEventTime().getTime()))).sorted(Comparator.comparingLong(InputLogEvent::getTimestamp)).collect(Collectors.toList());
    }

    private void createLogStream() {
        AWSLogs client = this.getClient();
        CreateLogStreamRequest req = new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName);
        LOG.info((Object)String.format("Creating Log Stream `%s` in Log Group `%s`", this.logStreamName, this.logGroupName));
        client.createLogStream(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AWSLogs getClient() {
        if (this.logsClient != null) return this.logsClient;
        Class<AmazonCloudWatchAuditDestination> clazz = AmazonCloudWatchAuditDestination.class;
        synchronized (AmazonCloudWatchAuditDestination.class) {
            if (this.logsClient != null) return this.logsClient;
            this.logsClient = this.newClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.logsClient;
        }
    }

    private AWSLogs newClient() {
        if (StringUtils.isBlank((String)this.regionName)) {
            return (AWSLogs)AWSLogsClientBuilder.standard().build();
        }
        return (AWSLogs)((AWSLogsClientBuilder)AWSLogsClientBuilder.standard().withRegion(this.regionName)).build();
    }
}

