/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequestUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"fileTable", "directoryTable", "snapshotRenamedTable"})
public class OMKeyRenameResponseWithFSO
extends OMKeyRenameResponse {
    private boolean isRenameDirectory;
    private OmKeyInfo fromKeyParent;
    private OmKeyInfo toKeyParent;
    private OmBucketInfo bucketInfo;

    public OMKeyRenameResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, String fromDBKey, String toDBKey, OmKeyInfo fromKeyParent, OmKeyInfo toKeyParent, @Nonnull OmKeyInfo renameKeyInfo, OmBucketInfo bucketInfo, boolean isRenameDirectory, BucketLayout bucketLayout) {
        super(omResponse, fromDBKey, toDBKey, renameKeyInfo, bucketLayout);
        this.isRenameDirectory = isRenameDirectory;
        this.fromKeyParent = fromKeyParent;
        this.toKeyParent = toKeyParent;
        this.bucketInfo = bucketInfo;
    }

    public OMKeyRenameResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        long volumeId = omMetadataManager.getVolumeId(this.getRenameKeyInfo().getVolumeName());
        long bucketId = omMetadataManager.getBucketId(this.getRenameKeyInfo().getVolumeName(), this.getRenameKeyInfo().getBucketName());
        if (this.isRenameDirectory) {
            omMetadataManager.getDirectoryTable().deleteWithBatch(batchOperation, (Object)this.getFromKeyName());
            OmDirectoryInfo renameDirInfo = OMFileRequest.getDirectoryInfo(this.getRenameKeyInfo());
            omMetadataManager.getDirectoryTable().putWithBatch(batchOperation, (Object)this.getToKeyName(), (Object)renameDirInfo);
        } else {
            omMetadataManager.getKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.getFromKeyName());
            omMetadataManager.getKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)this.getToKeyName(), (Object)this.getRenameKeyInfo());
        }
        boolean isSnapshotBucket = OMClientRequestUtils.isSnapshotBucket(omMetadataManager, this.getRenameKeyInfo());
        String renameDbKey = omMetadataManager.getRenameKey(this.getRenameKeyInfo().getVolumeName(), this.getRenameKeyInfo().getBucketName(), this.getRenameKeyInfo().getObjectID());
        String renamedKey = (String)omMetadataManager.getSnapshotRenamedTable().get((Object)renameDbKey);
        if (isSnapshotBucket && renamedKey == null) {
            omMetadataManager.getSnapshotRenamedTable().putWithBatch(batchOperation, (Object)renameDbKey, (Object)this.getFromKeyName());
        }
        if (this.fromKeyParent != null) {
            this.addDirToDBBatch(omMetadataManager, this.fromKeyParent, volumeId, bucketId, batchOperation);
        }
        if (this.toKeyParent != null) {
            this.addDirToDBBatch(omMetadataManager, this.toKeyParent, volumeId, bucketId, batchOperation);
        }
        if (this.bucketInfo != null) {
            String dbBucketKey = omMetadataManager.getBucketKey(this.bucketInfo.getVolumeName(), this.bucketInfo.getBucketName());
            omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)dbBucketKey, (Object)this.bucketInfo);
        }
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    private void addDirToDBBatch(OMMetadataManager metadataManager, OmKeyInfo keyInfo, long volumeId, long bucketId, BatchOperation batch) throws IOException {
        String dbKey = metadataManager.getOzonePathKey(volumeId, bucketId, keyInfo.getParentObjectID(), keyInfo.getFileName());
        OmDirectoryInfo keyDirInfo = OMFileRequest.getDirectoryInfo(keyInfo);
        metadataManager.getDirectoryTable().putWithBatch(batch, (Object)dbKey, (Object)keyDirInfo);
    }
}

