/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeySetTimesResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeySetTimesRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private final long modificationTime;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeySetTimesRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeySetTimesRequest.class);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.SetTimesRequest setTimesRequest = request.getSetTimesRequest();
        String keyPath = setTimesRequest.getKeyArgs().getKeyName();
        String normalizedKeyPath = OMKeySetTimesRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(this.getVolumeName()).setBucketName(this.getBucketName()).setKeyName(normalizedKeyPath).build();
        OzoneManagerProtocolProtos.KeyArgs newKeyArgs = this.resolveBucketLink(ozoneManager, keyArgs);
        return request.toBuilder().setSetTimesRequest(setTimesRequest.toBuilder().setKeyArgs(newKeyArgs).setMtime(this.getModificationTime())).build();
    }

    public OMKeySetTimesRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
        OzoneManagerProtocolProtos.SetTimesRequest setTimesRequest = this.getOmRequest().getSetTimesRequest();
        this.volumeName = setTimesRequest.getKeyArgs().getVolumeName();
        this.bucketName = setTimesRequest.getKeyArgs().getBucketName();
        this.keyName = setTimesRequest.getKeyArgs().getKeyName();
        this.modificationTime = setTimesRequest.getMtime();
    }

    protected String getVolumeName() {
        return this.volumeName;
    }

    protected String getBucketName() {
        return this.bucketName;
    }

    protected String getKeyName() {
        return this.keyName;
    }

    protected long getModificationTime() {
        return this.modificationTime;
    }

    protected OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    private OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetTimesResponse(OzoneManagerProtocolProtos.SetTimesResponse.newBuilder());
        return new OMKeySetTimesResponse(omResponse.build(), omKeyInfo);
    }

    protected OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception exception) {
        return new OMKeySetTimesResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
    }

    protected void onComplete(OMClientRequest.Result result, Exception exception, AuditLogger auditLogger, Map<String, String> auditMap) {
        switch (result) {
            case SUCCESS: {
                LOG.debug("Set mtime: {} to path: {} success!", (Object)this.modificationTime, (Object)this.getKeyName());
                break;
            }
            case FAILURE: {
                LOG.warn("Set mtime {} to path {} failed!", new Object[]{this.modificationTime, this.getKeyName(), exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeySetTimesRequest: {}", (Object)this.getOmRequest());
            }
        }
        auditMap.put("volume", this.getVolumeName());
        auditMap.put("bucket", this.getBucketName());
        auditMap.put("key", this.getKeyName());
        auditMap.put("modificationTime", String.valueOf(this.getModificationTime()));
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.SET_TIMES, auditMap, exception, this.getOmRequest().getUserInfo()));
    }

    protected void apply(OmKeyInfo omKeyInfo) {
        long mtime = this.getModificationTime();
        if (mtime >= 0L) {
            omKeyInfo.setModificationTime(this.getModificationTime());
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        block14: {
            long trxnLogIndex = context.getIndex();
            ozoneManager.getMetrics().incNumSetTime();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            boolean operationResult = false;
            try {
                try {
                    if (this.getModificationTime() < -1L) {
                        throw new OMException(OMException.ResultCodes.INVALID_REQUEST);
                    }
                    volume = this.getVolumeName();
                    bucket = this.getBucketName();
                    String key = this.getKeyName();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    String dbKey = omMetadataManager.getOzoneKey(volume, bucket, key);
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbKey);
                    if (omKeyInfo == null) {
                        throw new OMException(OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    operationResult = true;
                    this.apply(omKeyInfo);
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)omKeyInfo));
                    omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        this.onComplete(result, exception, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeySetTimesRequest.java", OMKeySetTimesRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeySetTimesRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 59);
    }
}

