/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.DeletingServiceMetrics;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyPurgeRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyPurgeRequest.class);

    public OMKeyPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        SnapshotInfo fromSnapshotInfo;
        OzoneManagerProtocolProtos.PurgeKeysRequest purgeKeysRequest = this.getOmRequest().getPurgeKeysRequest();
        List bucketDeletedKeysList = purgeKeysRequest.getDeletedKeysList();
        List keysToUpdateList = purgeKeysRequest.getKeysToUpdateList();
        String fromSnapshot = purgeKeysRequest.hasSnapshotTableKey() ? purgeKeysRequest.getSnapshotTableKey() : null;
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        try {
            SnapshotInfo snapshotInfo = fromSnapshotInfo = fromSnapshot != null ? SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot) : null;
            if (purgeKeysRequest.hasExpectedPreviousSnapshotID()) {
                UUID expectedPreviousSnapshotId = purgeKeysRequest.getExpectedPreviousSnapshotID().hasUuid() ? HddsUtils.fromProtobuf((HddsProtos.UUID)purgeKeysRequest.getExpectedPreviousSnapshotID().getUuid()) : null;
                SnapshotUtils.validatePreviousSnapshotId(fromSnapshotInfo, omMetadataManager.getSnapshotChainManager(), expectedPreviousSnapshotId);
            }
        }
        catch (IOException e) {
            LOG.error("Error occurred while performing OmKeyPurge. ", (Throwable)e);
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, e));
        }
        ArrayList<String> keysToBePurgedList = new ArrayList<String>();
        int numKeysDeleted = 0;
        for (OzoneManagerProtocolProtos.DeletedKeys bucketWithDeleteKeys : bucketDeletedKeysList) {
            List keysList = bucketWithDeleteKeys.getKeysList();
            keysToBePurgedList.addAll(keysList);
            numKeysDeleted += keysList.size();
        }
        DeletingServiceMetrics deletingServiceMetrics = ozoneManager.getDeletionMetrics();
        deletingServiceMetrics.incrNumKeysPurged(numKeysDeleted);
        if (keysToBePurgedList.isEmpty()) {
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, (Exception)((Object)new OMException("None of the keys can be purged be purged since a new snapshot was created for all the buckets, making this request invalid", OMException.ResultCodes.KEY_DELETION_ERROR))));
        }
        try {
            if (fromSnapshotInfo != null) {
                fromSnapshotInfo.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
                omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshotInfo.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshotInfo));
            }
        }
        catch (IOException e) {
            return new OMKeyPurgeResponse(this.createErrorOMResponse(omResponse, e));
        }
        return new OMKeyPurgeResponse(omResponse.build(), keysToBePurgedList, fromSnapshotInfo, keysToUpdateList);
    }
}

