/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMAuditLogger {
    private static final Map<OzoneManagerProtocolProtos.Type, OMAction> CMD_AUDIT_ACTION_MAP = new HashMap<OzoneManagerProtocolProtos.Type, OMAction>();
    private static final Logger LOG = LoggerFactory.getLogger(OMAuditLogger.class);

    static {
        OMAuditLogger.init();
    }

    private OMAuditLogger() {
    }

    private static void init() {
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateVolume, OMAction.CREATE_VOLUME);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteVolume, OMAction.DELETE_VOLUME);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateBucket, OMAction.CREATE_BUCKET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteBucket, OMAction.DELETE_BUCKET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.AddAcl, OMAction.ADD_ACL);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RemoveAcl, OMAction.REMOVE_ACL);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.SetAcl, OMAction.SET_ACL);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.GetDelegationToken, OMAction.GET_DELEGATION_TOKEN);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CancelDelegationToken, OMAction.CANCEL_DELEGATION_TOKEN);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RenewDelegationToken, OMAction.RENEW_DELEGATION_TOKEN);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.GetS3Secret, OMAction.GET_S3_SECRET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.SetS3Secret, OMAction.SET_S3_SECRET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RevokeS3Secret, OMAction.REVOKE_S3_SECRET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateTenant, OMAction.CREATE_TENANT);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteTenant, OMAction.DELETE_TENANT);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.TenantAssignUserAccessId, OMAction.TENANT_ASSIGN_USER_ACCESSID);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.TenantRevokeUserAccessId, OMAction.TENANT_REVOKE_USER_ACCESSID);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.TenantRevokeAdmin, OMAction.TENANT_REVOKE_ADMIN);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateSnapshot, OMAction.CREATE_SNAPSHOT);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteSnapshot, OMAction.DELETE_SNAPSHOT);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RenameSnapshot, OMAction.RENAME_SNAPSHOT);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RecoverLease, OMAction.RECOVER_LEASE);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateDirectory, OMAction.CREATE_DIRECTORY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateFile, OMAction.CREATE_FILE);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CreateKey, OMAction.ALLOCATE_KEY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.AllocateBlock, OMAction.ALLOCATE_BLOCK);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CommitKey, OMAction.COMMIT_KEY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteKey, OMAction.DELETE_KEY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteKeys, OMAction.DELETE_KEYS);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RenameKey, OMAction.RENAME_KEY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.RenameKeys, OMAction.RENAME_KEYS);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload, OMAction.INITIATE_MULTIPART_UPLOAD);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload, OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload, OMAction.ABORT_MULTIPART_UPLOAD);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload, OMAction.COMPLETE_MULTIPART_UPLOAD);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.SetTimes, OMAction.SET_TIMES);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.AbortExpiredMultiPartUploads, OMAction.ABORT_EXPIRED_MULTIPART_UPLOAD);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.SetVolumeProperty, OMAction.SET_OWNER);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.SetBucketProperty, OMAction.UPDATE_BUCKET);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.Prepare, OMAction.UPGRADE_PREPARE);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.CancelPrepare, OMAction.UPGRADE_CANCEL);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.FinalizeUpgrade, OMAction.UPGRADE_FINALIZE);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.GetObjectTagging, OMAction.GET_OBJECT_TAGGING);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.PutObjectTagging, OMAction.PUT_OBJECT_TAGGING);
        CMD_AUDIT_ACTION_MAP.put(OzoneManagerProtocolProtos.Type.DeleteObjectTagging, OMAction.DELETE_OBJECT_TAGGING);
    }

    private static OMAction getAction(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.Type cmdType = request.getCmdType();
        OMAction omAction = CMD_AUDIT_ACTION_MAP.get(cmdType);
        if (omAction != null) {
            boolean hasBucketOwner;
            boolean hasQuota;
            if (cmdType.equals((Object)OzoneManagerProtocolProtos.Type.SetVolumeProperty) && (hasQuota = request.getSetVolumePropertyRequest().hasQuotaInBytes())) {
                return OMAction.SET_QUOTA;
            }
            if (cmdType.equals((Object)OzoneManagerProtocolProtos.Type.SetBucketProperty) && (hasBucketOwner = request.getSetBucketPropertyRequest().getBucketArgs().hasOwnerName())) {
                return OMAction.SET_OWNER;
            }
        }
        return omAction;
    }

    public static void log(Builder builder, TermIndex termIndex) {
        if (builder.isLog.get()) {
            if (builder.getAuditMap() == null) {
                builder.setAuditMap(new HashMap<String, String>());
            }
            builder.getAuditMap().put("Transaction", String.valueOf(termIndex.getIndex()));
            builder.getMessageBuilder().withParams(builder.getAuditMap());
            builder.getAuditLogger().logWrite(builder.getMessageBuilder().build());
        }
    }

    public static void log(Builder builder) {
        if (builder.isLog.get()) {
            builder.getMessageBuilder().withParams(builder.getAuditMap());
            builder.getAuditLogger().logWrite(builder.getMessageBuilder().build());
        }
    }

    public static void log(Builder builder, OMClientRequest request, OzoneManager om, TermIndex termIndex, Throwable th) {
        if (builder.isLog.get()) {
            builder.getAuditLogger().logWrite(builder.getMessageBuilder().build());
            return;
        }
        OMAction action = OMAuditLogger.getAction(request.getOmRequest());
        if (action == null) {
            return;
        }
        if (builder.getAuditMap() == null) {
            builder.setAuditMap(new HashMap<String, String>());
        }
        try {
            builder.getAuditMap().put("Command", request.getOmRequest().getCmdType().name());
            builder.getAuditMap().put("Transaction", String.valueOf(termIndex.getIndex()));
            request.buildAuditMessage(action, builder.getAuditMap(), th, request.getUserInfo());
            builder.setLog(true);
            builder.setAuditLogger(om.getAuditLogger());
            OMAuditLogger.log(builder);
        }
        catch (Exception ex) {
            LOG.error("Exception occurred while write audit log, ", (Throwable)ex);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /* synthetic */ OMAuditLogger(OMAuditLogger oMAuditLogger) {
        this();
    }

    public static class Builder {
        private AuditMessage.Builder messageBuilder = new AuditMessage.Builder();
        private final AtomicBoolean isLog = new AtomicBoolean(false);
        private Map<String, String> auditMap = null;
        private AuditLogger auditLogger;

        public OMAuditLogger build() throws IOException {
            return new OMAuditLogger(null);
        }

        public AuditMessage.Builder getMessageBuilder() {
            return this.messageBuilder;
        }

        public void setLog(boolean flag) {
            this.isLog.set(flag);
        }

        public void setAuditLogger(AuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        public AuditLogger getAuditLogger() {
            return this.auditLogger;
        }

        public void setAuditMap(Map<String, String> auditMap) {
            this.auditMap = auditMap;
        }

        public Map<String, String> getAuditMap() {
            return this.auditMap;
        }
    }
}

