/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.DeleteKeysResult;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.IOzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.SstFilteringService;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.fs.OzoneManagerFS;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.service.DirectoryDeletingService;
import org.apache.hadoop.ozone.om.service.KeyDeletingService;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.om.service.SnapshotDirectoryCleaningService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public interface KeyManager
extends OzoneManagerFS,
IOzoneAcl {
    public void start(OzoneConfiguration var1);

    public void stop() throws IOException;

    public OmKeyInfo lookupKey(OmKeyArgs var1, ResolvedBucket var2, String var3) throws IOException;

    public OmKeyInfo getKeyInfo(OmKeyArgs var1, ResolvedBucket var2, String var3) throws IOException;

    public ListKeysResult listKeys(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public PendingKeysDeletion getPendingDeletionKeys(int var1) throws IOException;

    public List<Table.KeyValue<String, String>> getRenamesKeyEntries(String var1, String var2, String var3, int var4) throws IOException;

    public List<Table.KeyValue<String, List<OmKeyInfo>>> getDeletedKeyEntries(String var1, String var2, String var3, int var4) throws IOException;

    public ExpiredOpenKeys getExpiredOpenKeys(Duration var1, int var2, BucketLayout var3, Duration var4) throws IOException;

    public List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> getExpiredMultipartUploads(Duration var1, int var2) throws IOException;

    public Map<String, String> getObjectTagging(OmKeyArgs var1, ResolvedBucket var2) throws IOException;

    public OMMetadataManager getMetadataManager();

    public KeyDeletingService getDeletingService();

    public OmMultipartUploadList listMultipartUploads(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7) throws OMException;

    public OmMultipartUploadListParts listParts(String var1, String var2, String var3, String var4, int var5, int var6) throws IOException;

    public void refresh(OmKeyInfo var1) throws IOException;

    public TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getDeletedDirEntries(String var1, String var2) throws IOException;

    default public List<Table.KeyValue<String, OmKeyInfo>> getDeletedDirEntries(String volume, String bucket, int size) throws IOException {
        ArrayList<Table.KeyValue<String, OmKeyInfo>> deletedDirEntries = new ArrayList<Table.KeyValue<String, OmKeyInfo>>(size);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> iterator = this.getDeletedDirEntries(volume, bucket);){
            while (deletedDirEntries.size() < size && iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                deletedDirEntries.add((Table.KeyValue<String, OmKeyInfo>)Table.newKeyValue((Object)((String)kv.getKey()), (Object)((OmKeyInfo)kv.getValue())));
            }
            return deletedDirEntries;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DeleteKeysResult getPendingDeletionSubDirs(long var1, long var3, OmKeyInfo var5, long var6) throws IOException;

    public DeleteKeysResult getPendingDeletionSubFiles(long var1, long var3, OmKeyInfo var5, long var6) throws IOException;

    public DirectoryDeletingService getDirDeletingService();

    public BackgroundService getOpenKeyCleanupService();

    public BackgroundService getMultipartUploadCleanupService();

    public SstFilteringService getSnapshotSstFilteringService();

    public SnapshotDeletingService getSnapshotDeletingService();

    public SnapshotDirectoryCleaningService getSnapshotDirectoryService();
}

