/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="revoke-admin", aliases={"revokeadmin"}, description={"Revoke admin role from accessIds in a tenant"})
public class TenantRevokeAdminHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Access ID"}, arity="1..1")
    private String accessId;
    @CommandLine.Option(names={"-t", "--tenant"}, description={"Tenant name"})
    private String tenantId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        client.getObjectStore().tenantRevokeAdmin(this.accessId, this.tenantId);
        if (this.isVerbose()) {
            ObjectNode obj = JsonUtils.createObjectNode(null);
            obj.put("accessId", this.accessId);
            obj.put("tenantId", this.tenantId);
            obj.put("isAdmin", false);
            obj.put("isDelegatedAdmin", false);
            String jsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)obj);
            this.out().println(jsonString);
        }
    }
}

