/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handler
extends AbstractSubcommand
implements Callable<Void> {
    protected static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    private OzoneConfiguration conf;

    protected OzoneAddress getAddress() throws OzoneClientException {
        return new OzoneAddress();
    }

    protected abstract void execute(OzoneClient var1, OzoneAddress var2) throws IOException;

    protected boolean isApplicable() {
        return true;
    }

    @Override
    public Void call() throws Exception {
        this.conf = this.getOzoneConf();
        if (!this.isApplicable()) {
            return null;
        }
        OzoneAddress address = this.getAddress();
        try (OzoneClient client = this.createClient(address);){
            if (this.isVerbose()) {
                address.print(this.out());
            }
            this.execute(client, address);
        }
        return null;
    }

    protected OzoneClient createClient(OzoneAddress address) throws IOException {
        return address.createClient((MutableConfigurationSource)this.conf);
    }

    protected boolean securityEnabled() {
        boolean enabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf);
        if (!enabled) {
            this.err().printf("Error: '%s' operation works only when security is enabled. To enable security set ozone.security.enabled to true.%n", this.spec().qualifiedName().trim());
        }
        return enabled;
    }

    protected void printObjectAsJson(Object o) throws IOException {
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)o));
    }

    protected int printAsJsonArray(Iterator<?> iterator, int limit) {
        int counter;
        ArrayNode arrayNode = JsonUtils.createArrayNode();
        for (counter = 0; limit > counter && iterator.hasNext(); ++counter) {
            arrayNode.add((JsonNode)JsonUtils.createObjectNode(iterator.next()));
        }
        this.out().println(arrayNode.toPrettyString());
        return counter;
    }

    protected void printMsg(String msg) {
        this.out().println(msg);
    }

    protected OzoneConfiguration getConf() {
        return this.conf;
    }
}

