/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.view;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxBasicShape;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;

public class mxInteractiveCanvas
extends mxGraphics2DCanvas {
    protected ImageObserver imageObserver = null;

    public mxInteractiveCanvas() {
        this((ImageObserver)null);
    }

    public mxInteractiveCanvas(ImageObserver imageObserver) {
        this.setImageObserver(imageObserver);
    }

    public void setImageObserver(ImageObserver value) {
        this.imageObserver = value;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    protected void drawImageImpl(Image image, int x, int y) {
        this.g.drawImage(image, x, y, this.imageObserver);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(this.imageObserver), image.getHeight(this.imageObserver));
    }

    public boolean contains(mxGraphComponent graphComponent, Rectangle rect, mxCellState state) {
        return state != null && state.getX() >= (double)rect.x && state.getY() >= (double)rect.y && state.getX() + state.getWidth() <= (double)(rect.x + rect.width) && state.getY() + state.getHeight() <= (double)(rect.y + rect.height);
    }

    public boolean intersects(mxGraphComponent graphComponent, Rectangle rect, mxCellState state) {
        if (state != null) {
            if (state.getLabelBounds() != null && state.getLabelBounds().getRectangle().intersects(rect)) {
                return true;
            }
            int pointCount = state.getAbsolutePointCount();
            if (pointCount > 0) {
                mxIShape shape;
                rect = (Rectangle)rect.clone();
                int tolerance = graphComponent.getTolerance();
                rect.grow(tolerance, tolerance);
                Shape realShape = null;
                if (mxUtils.getString(state.getStyle(), mxConstants.STYLE_SHAPE, "").equals("arrow") && (shape = this.getShape(state.getStyle())) instanceof mxBasicShape) {
                    realShape = ((mxBasicShape)shape).createShape(this, state);
                }
                if (realShape != null && realShape.intersects(rect)) {
                    return true;
                }
                mxPoint p0 = state.getAbsolutePoint(0);
                for (int i = 0; i < pointCount; ++i) {
                    mxPoint p1 = state.getAbsolutePoint(i);
                    if (rect.intersectsLine(p0.getX(), p0.getY(), p1.getX(), p1.getY())) {
                        return true;
                    }
                    p0 = p1;
                }
            } else {
                return state.getRectangle().intersects(rect);
            }
        }
        return false;
    }

    public boolean hitSwimlaneContent(mxGraphComponent graphComponent, mxCellState swimlane, int x, int y) {
        if (swimlane != null) {
            int start = (int)Math.max(2L, Math.round((double)mxUtils.getInt(swimlane.getStyle(), mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * graphComponent.getGraph().getView().getScale()));
            Rectangle rect = swimlane.getRectangle();
            if (mxUtils.isTrue(swimlane.getStyle(), mxConstants.STYLE_HORIZONTAL, true)) {
                rect.y += start;
                rect.height -= start;
            } else {
                rect.x += start;
                rect.width -= start;
            }
            return rect.contains(x, y);
        }
        return false;
    }
}

