/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.scm.cert;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CAType;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.debug.DBDefinitionFactory;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import picocli.CommandLine;

@CommandLine.Command(name="recover", description={"Recover Deleted SCM Certificate from RocksDB"})
public class RecoverSCMCertificate
extends RepairTool {
    @CommandLine.Option(names={"--db"}, required=true, description={"SCM DB Path"})
    private String dbPath;

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.SCM;
    }

    @Override
    public void execute() throws Exception {
        this.dbPath = OzoneFSUtils.removeTrailingSlashIfNeeded((String)this.dbPath);
        String tableName = SCMDBDefinition.VALID_SCM_CERTS.getName();
        DBDefinition dbDefinition = DBDefinitionFactory.getDefinition(Paths.get(this.dbPath, new String[0]), (ConfigurationSource)new OzoneConfiguration());
        if (dbDefinition == null) {
            throw new Exception("Error: Incorrect DB Path");
        }
        DBColumnFamilyDefinition columnFamilyDefinition = RecoverSCMCertificate.getDbColumnFamilyDefinition(tableName, dbDefinition);
        try {
            List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.dbPath);
            ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
            byte[] tableNameBytes = tableName.getBytes(StandardCharsets.UTF_8);
            ColumnFamilyHandle cfHandle = null;
            try (ManagedRocksDB db = ManagedRocksDB.openReadOnly((String)this.dbPath, cfDescList, cfHandleList);){
                cfHandle = RecoverSCMCertificate.getColumnFamilyHandle(cfHandleList, tableNameBytes);
                SecurityConfig securityConfig = new SecurityConfig((ConfigurationSource)this.getOzoneConf());
                Map<BigInteger, X509Certificate> allCerts = RecoverSCMCertificate.getAllCerts(columnFamilyDefinition, cfHandle, db);
                this.info("All Certs in DB : %s", allCerts.keySet());
                String hostName = InetAddress.getLocalHost().getHostName();
                this.info("Host: %s", hostName);
                X509Certificate subCertificate = RecoverSCMCertificate.getSubCertificate(allCerts, hostName);
                X509Certificate rootCertificate = RecoverSCMCertificate.getRootCertificate(allCerts);
                this.info("Sub cert serialID for this host: %s", subCertificate.getSerialNumber());
                this.info("Root cert serialID: %s", rootCertificate.getSerialNumber());
                boolean isRootCA = false;
                String caPrincipal = rootCertificate.getSubjectDN().getName();
                if (caPrincipal.contains(hostName)) {
                    isRootCA = true;
                }
                this.storeCerts(subCertificate, rootCertificate, isRootCA, securityConfig);
            }
        }
        catch (CertificateException | RocksDBException exception) {
            this.error("Failed to recover scm cert", new Object[0]);
        }
    }

    private static ColumnFamilyHandle getColumnFamilyHandle(List<ColumnFamilyHandle> cfHandleList, byte[] tableNameBytes) throws Exception {
        ColumnFamilyHandle cfHandle = null;
        for (ColumnFamilyHandle cf : cfHandleList) {
            if (!Arrays.equals(cf.getName(), tableNameBytes)) continue;
            cfHandle = cf;
            break;
        }
        if (cfHandle == null) {
            throw new Exception("Error: VALID_SCM_CERTS table not found in DB");
        }
        return cfHandle;
    }

    private static X509Certificate getRootCertificate(Map<BigInteger, X509Certificate> allCerts) throws Exception {
        Optional<X509Certificate> cert = allCerts.values().stream().filter(c -> c.getSubjectDN().getName().contains("scm@")).findFirst();
        if (!cert.isPresent()) {
            throw new Exception("Root CA Cert not found in the DB for this host, Certs in the DB : " + allCerts.keySet());
        }
        return cert.get();
    }

    private static X509Certificate getSubCertificate(Map<BigInteger, X509Certificate> allCerts, String hostName) throws Exception {
        Optional<X509Certificate> cert = allCerts.values().stream().filter(c -> c.getSubjectDN().getName().contains("scm-sub@") && c.getSubjectDN().getName().contains(hostName)).findFirst();
        if (!cert.isPresent()) {
            throw new Exception("Sub CA Cert not found in the DB for this host, Certs in the DB : " + allCerts.keySet());
        }
        return cert.get();
    }

    private static Map<BigInteger, X509Certificate> getAllCerts(DBColumnFamilyDefinition columnFamilyDefinition, ColumnFamilyHandle cfHandle, ManagedRocksDB db) throws IOException, RocksDBException {
        HashMap<BigInteger, X509Certificate> allCerts = new HashMap<BigInteger, X509Certificate>();
        ManagedRocksIterator rocksIterator = ManagedRocksIterator.managed((RocksIterator)((RocksDB)db.get()).newIterator(cfHandle));
        ((RocksIterator)rocksIterator.get()).seekToFirst();
        while (((RocksIterator)rocksIterator.get()).isValid()) {
            BigInteger id = (BigInteger)columnFamilyDefinition.getKeyCodec().fromPersistedFormat(((RocksIterator)rocksIterator.get()).key());
            X509Certificate certificate = (X509Certificate)columnFamilyDefinition.getValueCodec().fromPersistedFormat(((RocksIterator)rocksIterator.get()).value());
            allCerts.put(id, certificate);
            ((RocksIterator)rocksIterator.get()).next();
        }
        return allCerts;
    }

    private static DBColumnFamilyDefinition getDbColumnFamilyDefinition(String tableName, DBDefinition dbDefinition) throws Exception {
        DBColumnFamilyDefinition columnFamilyDefinition = dbDefinition.getColumnFamily(tableName);
        if (columnFamilyDefinition == null) {
            throw new Exception("Error: VALID_SCM_CERTS table no found in Definition");
        }
        return columnFamilyDefinition;
    }

    private void storeCerts(X509Certificate scmCertificate, X509Certificate rootCertificate, boolean isRootCA, SecurityConfig securityConfig) throws CertificateException, IOException {
        CertificateCodec certCodec = new CertificateCodec(securityConfig, SCMCertificateClient.COMPONENT_NAME);
        CertPath certPath = this.addRootCertInPath(scmCertificate, rootCertificate);
        CertPath rootCertPath = this.getRootCertPath(rootCertificate);
        String encodedCert = CertificateCodec.getPEMEncodedString((CertPath)certPath);
        String certName = String.format("%s.crt", CAType.NONE.getFileNamePrefix() + scmCertificate.getSerialNumber());
        this.writeCertificate(certCodec, certName, encodedCert);
        String rootCertName = String.format("%s.crt", CAType.SUBORDINATE.getFileNamePrefix() + rootCertificate.getSerialNumber());
        String encodedRootCert = CertificateCodec.getPEMEncodedString((CertPath)rootCertPath);
        this.writeCertificate(certCodec, rootCertName, encodedRootCert);
        this.writeCertificate(certCodec, securityConfig.getCertificateFileName(), encodedCert);
        if (isRootCA) {
            CertificateCodec rootCertCodec = new CertificateCodec(securityConfig, OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
            this.writeCertificate(rootCertCodec, securityConfig.getCertificateFileName(), encodedRootCert);
        }
    }

    private void writeCertificate(CertificateCodec codec, String name, String encodedCert) throws IOException {
        this.info("Writing cert %s to %s", name, codec.getLocation());
        if (!this.isDryRun()) {
            codec.writeCertificate(name, encodedCert);
        }
    }

    public CertPath addRootCertInPath(X509Certificate scmCert, X509Certificate rootCert) throws CertificateException {
        ArrayList<X509Certificate> updatedList = new ArrayList<X509Certificate>();
        updatedList.add(scmCert);
        updatedList.add(rootCert);
        CertificateFactory certFactory = CertificateCodec.getCertFactory();
        return certFactory.generateCertPath(updatedList);
    }

    public CertPath getRootCertPath(X509Certificate rootCert) throws CertificateException {
        ArrayList<X509Certificate> updatedList = new ArrayList<X509Certificate>();
        updatedList.add(rootCert);
        CertificateFactory factory = CertificateCodec.getCertFactory();
        return factory.generateCertPath(updatedList);
    }
}

