/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.ldb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCompactRangeOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.util.Time;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import picocli.CommandLine;

@CommandLine.Command(name="compact", description={"CLI to compact a column-family in the DB while the service is offline.\nNote: If om.db is compacted with this tool then it will negatively impact the Ozone Manager's efficient snapshot diff."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class RocksDBManualCompaction
extends RepairTool {
    @CommandLine.Option(names={"--db"}, required=true, description={"Database File Path"})
    private String dbPath;
    @CommandLine.Option(names={"--column-family", "--column_family", "--cf"}, required=true, description={"Column family name"})
    private String columnFamilyName;

    @Override
    public void execute() throws Exception {
        ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
        List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.dbPath);
        try (ManagedRocksDB db = ManagedRocksDB.open((String)this.dbPath, cfDescList, cfHandleList);){
            ColumnFamilyHandle cfh = RocksDBUtils.getColumnFamilyHandle(this.columnFamilyName, cfHandleList);
            if (cfh == null) {
                throw new IllegalArgumentException(this.columnFamilyName + " is not in a column family in DB for the given path.");
            }
            this.info("Running compaction on " + this.columnFamilyName, new Object[0]);
            long startTime = Time.monotonicNow();
            if (!this.isDryRun()) {
                ManagedCompactRangeOptions compactOptions = new ManagedCompactRangeOptions();
                compactOptions.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
                ((RocksDB)db.get()).compactRange(cfh, null, null, (CompactRangeOptions)compactOptions);
            }
            long duration = Time.monotonicNow() - startTime;
            this.info("Compaction completed in " + duration + "ms.", new Object[0]);
        }
        catch (RocksDBException exception) {
            this.error("Exception: " + (Object)((Object)exception), new Object[0]);
            String errorMsg = "Failed to compact RocksDB for the given path: " + this.dbPath + ", column family: " + this.columnFamilyName;
            throw new IOException(errorMsg, exception);
        }
        finally {
            IOUtils.closeQuietly(cfHandleList);
        }
    }
}

