/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.fsck;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.fsck.BlockIdDetails;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ContainerMapper {
    public static void main(String[] args) throws IOException {
        String path = args[0];
        if (path == null) {
            throw new IOException("Path cannot be null");
        }
        OzoneConfiguration configuration = new OzoneConfiguration();
        configuration.set("ozone.om.db.dirs", path);
        ContainerMapper containerMapper = new ContainerMapper();
        Map<Long, List<Map<Long, BlockIdDetails>>> dataMap = containerMapper.parseOmDB(configuration);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString(dataMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<Map<Long, BlockIdDetails>>> parseOmDB(OzoneConfiguration configuration) throws IOException {
        String path = configuration.get("ozone.om.db.dirs");
        if (path == null || path.isEmpty()) {
            throw new IOException("ozone.om.db.dirsshould be set ");
        }
        OmMetadataManagerImpl metadataManager = new OmMetadataManagerImpl(configuration, null);
        try {
            Table keyTable = metadataManager.getKeyTable(ContainerMapper.getBucketLayout());
            HashMap<Long, List<Map<Long, BlockIdDetails>>> dataMap = new HashMap<Long, List<Map<Long, BlockIdDetails>>>();
            if (keyTable != null) {
                try (TableIterator keyValueTableIterator = keyTable.iterator();){
                    while (keyValueTableIterator.hasNext()) {
                        Table.KeyValue keyValue = (Table.KeyValue)keyValueTableIterator.next();
                        OmKeyInfo omKeyInfo = (OmKeyInfo)keyValue.getValue();
                        byte[] value = omKeyInfo.getProtobuf(true, ClientVersion.CURRENT_VERSION).toByteArray();
                        OmKeyInfo keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)OzoneManagerProtocolProtos.KeyInfo.parseFrom((byte[])value));
                        for (OmKeyLocationInfoGroup keyLocationInfoGroup : keyInfo.getKeyLocationVersions()) {
                            List keyLocationInfo = keyLocationInfoGroup.getLocationList();
                            for (OmKeyLocationInfo keyLocation : keyLocationInfo) {
                                BlockIdDetails blockIdDetails = new BlockIdDetails();
                                HashMap<Long, BlockIdDetails> innerMap = new HashMap<Long, BlockIdDetails>();
                                long containerID = keyLocation.getBlockID().getContainerID();
                                long blockID = keyLocation.getBlockID().getLocalID();
                                blockIdDetails.setBucketName(keyInfo.getBucketName());
                                blockIdDetails.setBlockVol(keyInfo.getVolumeName());
                                blockIdDetails.setKeyName(keyInfo.getKeyName());
                                List<HashMap<Long, BlockIdDetails>> innerList = new ArrayList<HashMap<Long, BlockIdDetails>>();
                                innerMap.put(blockID, blockIdDetails);
                                if (dataMap.containsKey(containerID)) {
                                    innerList = (List)dataMap.get(containerID);
                                }
                                innerList.add(innerMap);
                                dataMap.put(containerID, innerList);
                            }
                        }
                    }
                }
            }
            HashMap<Long, List<Map<Long, BlockIdDetails>>> hashMap = dataMap;
            return hashMap;
        }
        finally {
            metadataManager.stop();
        }
    }

    private static BucketLayout getBucketLayout() {
        return BucketLayout.DEFAULT;
    }
}

