/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.freon.S3EntityGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="s3bg", aliases={"s3-bucket-generator"}, description={"Create buckets via the s3 interface.\nCommand requires AWS authentication environment variables set, AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class S3BucketGenerator
extends S3EntityGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(S3BucketGenerator.class);
    private Timer timer;

    @Override
    public Void call() throws Exception {
        this.s3ClientInit();
        this.timer = this.getMetrics().timer("bucket-create");
        this.runTests(this::createBucket);
        return null;
    }

    private void createBucket(long bucketNum) throws Exception {
        String bName = this.getPrefix() + bucketNum;
        this.timer.time(() -> {
            this.getS3().createBucket(bName);
            return null;
        });
    }
}

