/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.conf.OzoneGetConf;
import picocli.CommandLine;

@CommandLine.Command(name="confKey", aliases={"-confKey"}, description={"gets a specific key from the configuration"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class PrintConfKeyCommandHandler
implements Callable<Void> {
    @CommandLine.Parameters(arity="1..1", description={"configuration key"})
    private String confKey;
    @CommandLine.ParentCommand
    private OzoneGetConf tool;

    @Override
    public Void call() throws Exception {
        String value = this.tool.getConf().getTrimmed(this.confKey);
        if (value == null) {
            throw new IllegalArgumentException("Configuration " + this.confKey + " is missing.");
        }
        this.tool.printOut(value);
        return null;
    }
}

