/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel1;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel2;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class SharableLibrariesUtils {
    static final String PROP_LOCATION = "location";
    static final String PROP_ACTIONS = "actions";
    static final String PROP_HELPER = "helper";
    static final String PROP_REFERENCE_HELPER = "refhelper";
    static final String PROP_LIBRARIES = "libraries";
    static final String PROP_JAR_REFS = "jars";
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";
    private static String PROP_LAST_SHARABLE = "lastSharable";

    public static boolean isLastProjectSharable() {
        return NbPreferences.forModule(SharableLibrariesUtils.class).getBoolean(PROP_LAST_SHARABLE, NbPreferences.root().node("org.netbeans.modules.java.project.share").getBoolean(PROP_LAST_SHARABLE, false));
    }

    public static void setLastProjectSharable(boolean sharable) {
        NbPreferences.forModule(SharableLibrariesUtils.class).putBoolean(PROP_LAST_SHARABLE, sharable);
    }

    public static String browseForLibraryLocation(String current, Component comp, File projectLocation) {
        File lib = PropertyUtils.resolveFile(projectLocation, current);
        if (!lib.exists()) {
            lib = lib.getParentFile();
        }
        lib = FileUtil.normalizeFile(lib);
        FileChooser chooser = new FileChooser(projectLocation, null);
        chooser.setCurrentDirectory(lib);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Bundle.LBL_Browse_Libraries_Title());
        chooser.getAccessibleContext().setAccessibleDescription(Bundle.ASCD_Browse_Libraries_Title());
        if (0 == chooser.showOpenDialog(comp)) {
            String[] files;
            try {
                files = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
                return null;
            }
            if (files.length == 1) {
                String currentLibrariesLocation = files[0];
                return currentLibrariesLocation;
            }
        }
        return null;
    }

    public static boolean showMakeSharableWizard(AntProjectHelper helper, ReferenceHelper ref, List<String> libraryNames, List<String> jarReferences) {
        CopyIterator cpIt = new CopyIterator(helper);
        WizardDescriptor wizardDescriptor = new WizardDescriptor(cpIt);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(Bundle.TIT_MakeSharableWizard());
        wizardDescriptor.putProperty(PROP_HELPER, helper);
        wizardDescriptor.putProperty(PROP_REFERENCE_HELPER, ref);
        wizardDescriptor.putProperty(PROP_LIBRARIES, libraryNames);
        wizardDescriptor.putProperty(PROP_JAR_REFS, jarReferences);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_MakeSharableWizard());
        dialog.setVisible(true);
        dialog.toFront();
        return wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION && cpIt.isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(WizardDescriptor wizardDescriptor, final AntProjectHelper helper, final ProgressHandle handle) throws IOException {
        final String loc = (String)wizardDescriptor.getProperty(PROP_LOCATION);
        final List<Action> actions = NbCollections.checkedListByCopy((List)wizardDescriptor.getProperty(PROP_ACTIONS), Action.class, true);
        assert (loc != null);
        handle.start(Math.max(1, actions.size() + 1));
        try {
            File f = new File(loc);
            if (!f.isAbsolute()) {
                f = new File(FileUtil.toFile(helper.getProjectDirectory()), loc);
            }
            if (!(f = FileUtil.normalizeFile(f)).exists()) {
                FileUtil.createData(f);
            }
            if (!f.isFile()) {
                throw new IllegalArgumentException("Library definition has to be file, got: " + f.getAbsolutePath());
            }
            try {
                final ArrayDeque errors = new ArrayDeque();
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        try {
                            helper.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                @Override
                                public void run() throws IOException {
                                    helper.setLibrariesLocation(loc);
                                    int count = 1;
                                    for (Action act : actions) {
                                        handle.progress(count);
                                        ++count;
                                        act.actionPerformed(null);
                                        if (!(act instanceof ErrorProvider)) continue;
                                        try {
                                            String err = ((ErrorProvider)((Object)act)).getError();
                                            if (err == null) continue;
                                            errors.offer(err);
                                        }
                                        catch (Exception e) {
                                            Exceptions.printStackTrace(e);
                                        }
                                    }
                                    ProjectManager.getDefault().saveProject(FileOwnerQuery.getOwner(helper.getProjectDirectory()));
                                }
                            });
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IOException(ex);
                        }
                        return null;
                    }
                });
                if (!errors.isEmpty()) {
                    Object content;
                    if (errors.size() == 1) {
                        content = errors.iterator().next();
                    } else {
                        JPanel panel = new JPanel();
                        panel.setLayout(new GridBagLayout());
                        JLabel label = new JLabel(Bundle.LBL_ExecuteProblems());
                        GridBagConstraints c = new GridBagConstraints();
                        c.gridx = 0;
                        c.gridy = 0;
                        c.gridwidth = 0;
                        c.gridheight = 1;
                        c.fill = 2;
                        c.weightx = 1.0;
                        c.weighty = 0.0;
                        c.anchor = 17;
                        c.insets = new Insets(6, 6, 6, 6);
                        panel.add((Component)label, c);
                        JList<Object> list = new JList<Object>(errors.toArray());
                        c = new GridBagConstraints();
                        c.gridx = 0;
                        c.gridy = 1;
                        c.gridwidth = 0;
                        c.gridheight = 1;
                        c.fill = 2;
                        c.weightx = 1.0;
                        c.weighty = 1.0;
                        c.anchor = 17;
                        c.insets = new Insets(0, 6, 6, 6);
                        panel.add((Component)new JScrollPane(list), c);
                        content = panel;
                    }
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(content, 2));
                }
            }
            catch (MutexException ex) {
                throw (IOException)ex.getException();
            }
        }
        finally {
            handle.finish();
        }
    }

    private static List<WizardDescriptor.Panel<WizardDescriptor>> getPanels() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        panels.add(new MakeSharableWizardPanel1());
        panels.add(new MakeSharableWizardPanel2());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return panels;
    }

    private static String getJarFolder(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1 && index + 2 < u.length()) {
            return u.substring(index + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class CopyIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor>
    implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
        private AntProjectHelper helper;
        private WizardDescriptor desc;
        private volatile boolean success;

        private CopyIterator(AntProjectHelper helper) {
            super(SharableLibrariesUtils.getPanels());
            this.helper = helper;
        }

        @Override
        public Set instantiate(ProgressHandle handle) throws IOException {
            SharableLibrariesUtils.execute(this.desc, this.helper, handle);
            this.success = true;
            return Collections.EMPTY_SET;
        }

        @Override
        public Set instantiate() throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void initialize(WizardDescriptor wizard) {
            this.desc = wizard;
        }

        @Override
        public void uninitialize(WizardDescriptor wizard) {
            this.desc = wizard;
        }

        boolean isSuccess() {
            return this.success;
        }
    }

    static class CopyLibraryJars
    extends AbstractAction {
        private Library library;
        private ReferenceHelper refHelper;

        CopyLibraryJars(ReferenceHelper h, Library l) {
            this.refHelper = h;
            this.library = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (this.library.getManager() == LibraryManager.getDefault()) : "Only converting from non-sharable to sharable is supported.";
            try {
                this.refHelper.copyLibrary(this.library);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    static class KeepLibraryAtLocation
    extends AbstractAction
    implements ErrorProvider {
        private boolean keepRelativeLocations;
        private Library library;
        private AntProjectHelper helper;
        private String errMsg;

        KeepLibraryAtLocation(Library l, boolean relative, AntProjectHelper h) {
            this.library = l;
            this.keepRelativeLocations = relative;
            this.helper = h;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String loc = this.helper.getLibrariesLocation();
            assert (loc != null);
            File mainPropertiesFile = this.helper.resolveFile(loc);
            try {
                LibraryManager man = LibraryManager.forLocation(Utilities.toURI(mainPropertiesFile).toURL());
                HashMap<String, List<URI>> volumes = new HashMap<String, List<URI>>();
                LibraryTypeProvider provider = LibrariesSupport.getLibraryTypeProvider(this.library.getType());
                assert (provider != null);
                for (String volume : provider.getSupportedVolumeTypes()) {
                    List<URL> urls = this.library.getContent(volume);
                    ArrayList<URI> newurls = new ArrayList<URI>();
                    for (URL url : urls) {
                        FileObject fo;
                        String jarFolder = null;
                        if ("jar".equals(url.getProtocol())) {
                            jarFolder = SharableLibrariesUtils.getJarFolder(URI.create(url.toExternalForm()));
                            url = FileUtil.getArchiveFile(url);
                        }
                        if ((fo = URLMapper.findFileObject(url)) != null) {
                            URI uri;
                            if (this.keepRelativeLocations) {
                                path = FileUtil.toFile(fo);
                                String str = PropertyUtils.relativizeFile(mainPropertiesFile.getParentFile(), path);
                                uri = str == null ? Utilities.toURI(path) : LibrariesSupport.convertFilePathToURI(str);
                            } else {
                                path = FileUtil.toFile(fo);
                                uri = Utilities.toURI(path);
                            }
                            if (FileUtil.isArchiveFile(fo)) {
                                uri = SharableLibrariesUtils.appendJarFolder(uri, jarFolder);
                            }
                            newurls.add(uri);
                            continue;
                        }
                        try {
                            newurls.add(url.toURI());
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace(ex);
                        }
                    }
                    volumes.put(volume, newurls);
                }
                if (man.getLibrary(this.library.getName()) != null) {
                    this.errMsg = Bundle.ERR_LibraryExists(this.library.getDisplayName());
                } else {
                    String displayName;
                    String name = this.library.getName();
                    if (name.equals(displayName = this.library.getDisplayName())) {
                        displayName = null;
                    }
                    man.createURILibrary(this.library.getType(), name, displayName, this.library.getDescription(), volumes);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        @Override
        @CheckForNull
        public String getError() {
            return this.errMsg;
        }
    }

    static class KeepJarAtLocation
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;
        private boolean relative;

        public KeepJarAtLocation(String ref, boolean b, AntProjectHelper anthelper, ReferenceHelper helper) {
            this.reference = ref;
            this.ahelper = anthelper;
            this.refhelper = helper;
            this.relative = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
            this.updateReference(value, this.reference, true);
            String source = this.reference.replace("${file.reference", "${source.reference");
            value = this.ahelper.getStandardPropertyEvaluator().evaluate(source);
            if (!value.startsWith("${source.")) {
                this.updateReference(value, source.replace("${", "").replace("}", ""), false);
            }
            String javadoc = this.reference.replace("${file.reference", "${javadoc.reference");
            value = this.ahelper.getStandardPropertyEvaluator().evaluate(javadoc);
            if (!value.startsWith("${javadoc.")) {
                this.updateReference(value, javadoc.replace("${", "").replace("}", ""), false);
            }
        }

        private void updateReference(String value, String key, boolean main) {
            String newVal;
            File absFile = this.ahelper.resolveFile(value);
            String string = newVal = this.relative ? PropertyUtils.relativizeFile(FileUtil.toFile(this.ahelper.getProjectDirectory()), absFile) : absFile.getAbsolutePath();
            if (newVal == null) {
                newVal = absFile.getAbsolutePath();
            }
            if (!newVal.equals(value)) {
                if (main) {
                    this.refhelper.createForeignFileReferenceAsIs(newVal, key);
                } else {
                    this.refhelper.createExtraForeignFileReferenceAsIs(newVal, key);
                }
            }
        }
    }

    static class CopyJars
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;

        public CopyJars(ReferenceHelper helper, AntProjectHelper anthelper, String ref) {
            this.reference = ref;
            this.ahelper = anthelper;
            this.refhelper = helper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String value = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
                File absFile = this.ahelper.resolveFile(value);
                String location = this.ahelper.getLibrariesLocation();
                File libraryFile = this.ahelper.resolveFile(location);
                File directory = libraryFile.getParentFile();
                FileObject dir = FileUtil.createFolder(directory);
                if (!absFile.exists()) {
                    return;
                }
                this.updateReference(absFile, this.reference, true, dir);
                String source = this.reference.replace("${file.reference", "${source.reference");
                value = this.ahelper.getStandardPropertyEvaluator().evaluate(source);
                if (!value.startsWith("${source.")) {
                    absFile = this.ahelper.resolveFile(value);
                    this.updateReference(absFile, source.replace("${", "").replace("}", ""), false, dir);
                }
                String javadoc = this.reference.replace("${file.reference", "${javadoc.reference");
                value = this.ahelper.getStandardPropertyEvaluator().evaluate(javadoc);
                if (!value.startsWith("${javadoc.")) {
                    absFile = this.ahelper.resolveFile(value);
                    this.updateReference(absFile, javadoc.replace("${", "").replace("}", ""), false, dir);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
        }

        private void updateReference(File oldFile, String key, boolean main, FileObject dir) {
            FileObject newFile;
            final FileObject src = FileUtil.toFileObject(oldFile);
            if (src == null) {
                assert (!oldFile.exists()) : "The file: " + oldFile.getAbsolutePath() + " exists but FileObject cannot be found.";
                return;
            }
            try {
                newFile = dir.getFileObject(src.getNameExt());
                if (newFile != null) {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(Bundle.TXT_AlreadyExists(src.getNameExt()), 2));
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        action.run();
                    } else {
                        SwingUtilities.invokeLater(action);
                    }
                } else {
                    newFile = FileUtil.copyFile(src, dir, src.getName());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
                newFile = src;
            }
            File absFile = FileUtil.toFile(newFile);
            String newVal = PropertyUtils.relativizeFile(FileUtil.toFile(this.ahelper.getProjectDirectory()), absFile);
            if (newVal == null) {
                newVal = absFile.getAbsolutePath();
            }
            if (main) {
                this.refhelper.destroyReference(key);
                this.refhelper.createForeignFileReferenceAsIs(newVal, key);
            } else {
                this.refhelper.destroyReference(key);
                this.refhelper.createExtraForeignFileReferenceAsIs(newVal, key);
            }
        }
    }

    static interface ErrorProvider {
        @CheckForNull
        public String getError();
    }
}

