/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.impl.ClassPathPackageAccessor;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

public class ClassPathModifierSupport {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private static final Logger LOG = Logger.getLogger(ClassPathModifierSupport.class.getName());

    @Deprecated
    public static boolean handleRoots(@NonNull Project project, @NonNull AntProjectHelper helper, @NonNull ClassPathSupport cs, @NonNull PropertyEvaluator eval, @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, @NonNull URI[] classPathRoots, @NonNull String classPathProperty, @NullAllowed String projectXMLElementName, int operation) throws IOException {
        Parameters.notNull("project", project);
        Parameters.notNull("helper", helper);
        Parameters.notNull("cs", cs);
        Parameters.notNull("eval", eval);
        Parameters.notNull("classPathProperty", classPathRoots);
        Parameters.notNull("classPathProperty", classPathProperty);
        return ClassPathModifierSupport.handleRootsImpl(project, helper, cs, eval, null, null, cpUiSupportCallback, classPathRoots, classPathProperty, projectXMLElementName, operation);
    }

    public static boolean handleRoots(@NonNull Project project, @NonNull UpdateHelper helper, @NonNull ClassPathSupport cs, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper, @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, @NonNull URI[] classPathRoots, @NonNull String classPathProperty, @NullAllowed String projectXMLElementName, int operation) throws IOException {
        Parameters.notNull("project", project);
        Parameters.notNull("helper", helper);
        Parameters.notNull("cs", cs);
        Parameters.notNull("eval", eval);
        Parameters.notNull("refHelper", refHelper);
        Parameters.notNull("classPathProperty", classPathRoots);
        Parameters.notNull("classPathProperty", classPathProperty);
        return ClassPathModifierSupport.handleRootsImpl(project, helper.getAntProjectHelper(), cs, eval, helper, refHelper, cpUiSupportCallback, classPathRoots, classPathProperty, projectXMLElementName, operation);
    }

    private static boolean handleRootsImpl(final @NonNull Project project, final @NonNull AntProjectHelper helper, final @NonNull ClassPathSupport cs, final @NonNull PropertyEvaluator eval, final @NullAllowed UpdateHelper updateHelper, final @NullAllowed ReferenceHelper rh, final @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, final @NonNull URI[] classPathRoots, final @NonNull String classPathProperty, final @NullAllowed String projectXMLElementName, final int operation) throws IOException {
        try {
            return ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    boolean changed = false;
                    File projectFolderFile = FileUtil.toFile(helper.getProjectDirectory());
                    for (int i = 0; i < classPathRoots.length; ++i) {
                        String filePath;
                        if (3 == operation || 2 == operation || !classPathRoots[i].isAbsolute()) {
                            URI toAdd = LibrariesSupport.getArchiveFile(classPathRoots[i]);
                            if (toAdd == null) {
                                toAdd = classPathRoots[i];
                            }
                            filePath = LibrariesSupport.convertURIToFilePath(toAdd);
                        } else {
                            filePath = Accessor.performHeuristics(classPathRoots[i], helper);
                        }
                        String filePath2 = filePath;
                        if (filePath2.startsWith("${var.")) {
                            filePath2 = eval.evaluate(filePath);
                        }
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(filePath2, projectFolderFile, null, filePath.startsWith("${var.") ? filePath : null);
                        if (cpUiSupportCallback != null) {
                            cpUiSupportCallback.initItem(item);
                        }
                        if (!(operation != 1 && operation != 3 || resources.contains(item))) {
                            resources.add(item);
                            changed = true;
                            continue;
                        }
                        if (operation != 2) continue;
                        Iterator<ClassPathSupport.Item> it = resources.iterator();
                        while (it.hasNext()) {
                            ClassPathSupport.Item resource = it.next();
                            if (!resource.equals(item) && (!resource.isBroken() || resource.getType() != 0 || !filePath.equals(resource.getFilePath()) && !filePath.equals(resource.getVariableBasedProperty()))) continue;
                            it.remove();
                            if (rh != null) {
                                assert (updateHelper != null);
                                ClassPathModifierSupport.removeUnusedReference(resource, classPathProperty, updateHelper, rh);
                            }
                            changed = true;
                        }
                    }
                    if (changed) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        if (updateHelper != null) {
                            updateHelper.putProperties("nbproject/project.properties", props);
                        } else {
                            helper.putProperties("nbproject/project.properties", props);
                        }
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            t.initCause(e);
            throw t;
        }
    }

    @Deprecated
    public static boolean handleAntArtifacts(@NonNull Project project, @NonNull AntProjectHelper helper, @NonNull ClassPathSupport cs, @NonNull PropertyEvaluator eval, @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, @NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull String classPathProperty, @NullAllowed String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        Parameters.notNull("project", project);
        Parameters.notNull("helper", helper);
        Parameters.notNull("cs", cs);
        Parameters.notNull("eval", eval);
        Parameters.notNull("artifacts", artifacts);
        Parameters.notNull("artifactElements", artifactElements);
        Parameters.notNull("classPathProperty", classPathProperty);
        if (artifacts.length != artifactElements.length) {
            throw new IllegalArgumentException("Each artifact has to have corresponding artifactElement");
        }
        return ClassPathModifierSupport.handleAntArtifactsImpl(project, helper, cs, eval, null, null, cpUiSupportCallback, artifacts, artifactElements, classPathProperty, projectXMLElementName, operation);
    }

    public static boolean handleAntArtifacts(@NonNull Project project, @NonNull UpdateHelper helper, @NonNull ClassPathSupport cs, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper, @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, @NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull String classPathProperty, @NullAllowed String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        Parameters.notNull("project", project);
        Parameters.notNull("helper", helper);
        Parameters.notNull("cs", cs);
        Parameters.notNull("eval", eval);
        Parameters.notNull("refHelper", refHelper);
        Parameters.notNull("artifacts", artifacts);
        Parameters.notNull("artifactElements", artifactElements);
        Parameters.notNull("classPathProperty", classPathProperty);
        if (artifacts.length != artifactElements.length) {
            throw new IllegalArgumentException("Each artifact has to have corresponding artifactElement");
        }
        return ClassPathModifierSupport.handleAntArtifactsImpl(project, helper.getAntProjectHelper(), cs, eval, helper, refHelper, cpUiSupportCallback, artifacts, artifactElements, classPathProperty, projectXMLElementName, operation);
    }

    private static boolean handleAntArtifactsImpl(final @NonNull Project project, final @NonNull AntProjectHelper helper, final @NonNull ClassPathSupport cs, @NonNull PropertyEvaluator eval, final @NullAllowed UpdateHelper updateHelper, final @NullAllowed ReferenceHelper rh, final @NullAllowed ClassPathUiSupport.Callback cpUiSupportCallback, final @NonNull AntArtifact[] artifacts, final @NonNull URI[] artifactElements, final @NonNull String classPathProperty, final @NullAllowed String projectXMLElementName, final int operation) throws IOException, UnsupportedOperationException {
        try {
            return ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    boolean changed = false;
                    for (int i = 0; i < artifacts.length; ++i) {
                        int index;
                        assert (artifacts[i] != null);
                        assert (artifactElements[i] != null);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(artifacts[i], artifactElements[i], null);
                        if (cpUiSupportCallback != null) {
                            cpUiSupportCallback.initItem(item);
                        }
                        if (operation == 1 && !resources.contains(item)) {
                            resources.add(item);
                            changed = true;
                            continue;
                        }
                        if (operation != 2 || (index = resources.indexOf(item)) < 0) continue;
                        ClassPathSupport.Item origin = resources.remove(index);
                        if (rh != null) {
                            assert (updateHelper != null);
                            ClassPathModifierSupport.removeUnusedReference(origin, classPathProperty, updateHelper, rh);
                        }
                        changed = true;
                    }
                    if (changed) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        if (updateHelper != null) {
                            updateHelper.putProperties("nbproject/project.properties", props);
                        } else {
                            helper.putProperties("nbproject/project.properties", props);
                        }
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public static boolean handleLibraries(Project project, AntProjectHelper helper, ClassPathSupport cs, PropertyEvaluator eval, ClassPathUiSupport.Callback cpUiSupportCallback, ReferenceHelper refHelper, Library[] libraries, String classPathProperty, String projectXMLElementName, int operation) throws IOException, UnsupportedOperationException {
        ArrayList<ClassPathSupport.Item> items = new ArrayList<ClassPathSupport.Item>(libraries.length);
        for (Library in : libraries) {
            if (in == null) {
                throw new IllegalArgumentException("Libraries array contains a null reference: " + Arrays.toString(libraries));
            }
            Library lib = ClassPathModifierSupport.checkLibrarySharability(project, helper, refHelper, in);
            ClassPathSupport.Item item = ClassPathSupport.Item.create(lib, null);
            if (cpUiSupportCallback != null) {
                cpUiSupportCallback.initItem(item);
            }
            items.add(item);
        }
        return ClassPathModifierSupport.handleLibraryClassPathItems(project, helper, cs, items, classPathProperty, projectXMLElementName, operation, true);
    }

    private static Library checkLibrarySharability(Project project, AntProjectHelper antHelper, ReferenceHelper refHelper, Library lib) throws IOException {
        if (antHelper.isSharableProject()) {
            if (lib.getManager().getLocation() == null) {
                LOG.log(Level.FINE, "Client is adding global library [" + lib + "] to sharable project.", new Exception());
                Library l = refHelper.getProjectLibraryManager().getLibrary(lib.getName());
                lib = l != null ? l : refHelper.copyLibrary(lib);
            } else if (!lib.getManager().getLocation().equals(refHelper.getProjectLibraryManager().getLocation())) {
                throw new UnsupportedOperationException("Adding library '" + lib.getName() + "' from '" + lib.getManager().getLocation() + "' to project '" + project.getProjectDirectory() + "' is not supported because project libraries are defined in '" + refHelper.getProjectLibraryManager().getLocation() + "'");
            }
        }
        return lib;
    }

    static boolean removeUnusedReference(@NonNull ClassPathSupport.Item item, @NonNull String classPathProperty, @NonNull UpdateHelper updateHelper, @NonNull ReferenceHelper rh) {
        if (ClassPathModifierSupport.isLastReference(item, updateHelper.getProperties("nbproject/project.properties"), classPathProperty)) {
            ClassPathModifierSupport.destroyReference(rh, updateHelper, item);
            return true;
        }
        return false;
    }

    private static boolean isLastReference(@NonNull ClassPathSupport.Item item, @NonNull EditableProperties props, @NonNull String ignoreProperty) {
        String property = CommonProjectUtils.getAntPropertyName(item.getReference());
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (ignoreProperty.equals(entry.getKey()) || !entry.getValue().contains(property)) continue;
            return false;
        }
        return true;
    }

    private static void destroyReference(@NonNull ReferenceHelper rh, @NonNull UpdateHelper uh, @NonNull ClassPathSupport.Item item) {
        if (item.getType() == 2 || item.getType() == 0) {
            rh.destroyReference(item.getReference());
            if (item.getType() == 0) {
                item.removeSourceAndJavadoc(uh);
            }
        }
    }

    public static boolean handleLibraryClassPathItems(final Project project, final AntProjectHelper helper, final ClassPathSupport cs, final List<ClassPathSupport.Item> items, final String classPathProperty, final String projectXMLElementName, final int operation, final boolean saveProject) throws IOException {
        assert (items != null) : "Libraries cannot be null";
        assert (classPathProperty != null);
        assert (saveProject || ProjectManager.mutex().isWriteAccess());
        try {
            return ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException {
                    EditableProperties props = helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathProperty);
                    List<ClassPathSupport.Item> resources = cs.itemsList(raw, projectXMLElementName);
                    ArrayList<ClassPathSupport.Item> changed = new ArrayList<ClassPathSupport.Item>(items.size());
                    for (ClassPathSupport.Item item : items) {
                        assert (item != null);
                        assert (item.getType() == 1);
                        if (operation == 1 && !resources.contains(item)) {
                            resources.add(item);
                            changed.add(item);
                            continue;
                        }
                        if (operation != 2 || !resources.contains(item)) continue;
                        resources.remove(item);
                        changed.add(item);
                    }
                    if (!changed.isEmpty()) {
                        String[] itemRefs = cs.encodeToStrings(resources, projectXMLElementName);
                        props = helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathProperty, itemRefs);
                        helper.putProperties("nbproject/project.properties", props);
                        if (saveProject) {
                            ProjectManager.getDefault().saveProject(project);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    static {
        ClassPathPackageAccessor.setInstance(new ClassPathPackageAccessorImpl());
    }

    private static class ClassPathPackageAccessorImpl
    extends ClassPathPackageAccessor {
        private ClassPathPackageAccessorImpl() {
        }

        @Override
        public boolean removeUnusedReference(ClassPathSupport.Item item, String classPathProperty, UpdateHelper updateHelper, ReferenceHelper rh) {
            return ClassPathModifierSupport.removeUnusedReference(item, classPathProperty, updateHelper, rh);
        }
    }

    private static class Accessor
    extends ProjectClassPathModifierImplementation {
        private Accessor() {
        }

        public static String performHeuristics(URI classpathRoot, AntProjectHelper helper) throws URISyntaxException, IOException {
            Accessor i = new Accessor();
            return i.performSharabilityHeuristics(classpathRoot, helper);
        }

        @Override
        protected SourceGroup[] getExtensibleSourceGroups() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean addLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean removeLibraries(Library[] libraries, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean addRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean removeRoots(URL[] classPathRoots, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, SourceGroup sourceGroup, String type) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

