/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navigation;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlCommandLink;
import org.apache.myfaces.custom.navigation.HtmlCommandNavigation;
import org.apache.myfaces.custom.navigation.HtmlPanelNavigation;

public abstract class AbstractHtmlCommandNavigation
extends HtmlCommandLink {
    private static final Log log = LogFactory.getLog((Class)AbstractHtmlCommandNavigation.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlCommandNavigation";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Navigation";

    public boolean isImmediate() {
        return true;
    }

    public void setImmediate(boolean immediate) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Immediate property of HtmlCommandNavigation cannot be set --> ignored.");
        }
    }

    public Boolean getOpenDirectly() {
        return this.isOpen();
    }

    public Boolean getActiveDirectly() {
        return this.isActive();
    }

    public boolean isRendered() {
        if (!super.isRendered()) {
            return false;
        }
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof HtmlCommandNavigation && !((HtmlCommandNavigation)parent).isOpen()) {
                return false;
            }
            if (parent instanceof HtmlPanelNavigation) break;
        }
        return true;
    }

    public abstract boolean isOpen();

    public abstract void setOpen(boolean var1);

    public abstract boolean isActive();

    public abstract void setActive(boolean var1);

    public void toggleOpen() {
        if (this.isOpen()) {
            if (this.getChildCount() > 0) {
                this.setOpen(false);
            }
        } else {
            UIComponent p;
            UIComponent parent = this.getParent();
            AbstractHtmlCommandNavigation.closeAllChildren(parent.getChildren().iterator());
            for (p = parent; p != null && !(p instanceof HtmlPanelNavigation); p = p.getParent()) {
                if (!(p instanceof HtmlCommandNavigation)) continue;
                ((HtmlCommandNavigation)p).setOpen(true);
            }
            if (!this.hasCommandNavigationChildren()) {
                if (!(p instanceof HtmlPanelNavigation)) {
                    log.error((Object)"HtmlCommandNavigation without parent HtmlPanelNavigation ?!");
                } else {
                    AbstractHtmlCommandNavigation.deactivateAllChildren(p.getChildren().iterator());
                }
                this.setActive(true);
            } else {
                this.setOpen(true);
            }
        }
    }

    private boolean hasCommandNavigationChildren() {
        if (this.getChildCount() == 0) {
            return false;
        }
        List list = this.getChildren();
        int sizei = list.size();
        for (int i = 0; i < sizei; ++i) {
            if (!(list.get(i) instanceof HtmlCommandNavigation)) continue;
            return true;
        }
        return false;
    }

    private static void deactivateAllChildren(Iterator children) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigation)) continue;
            ((HtmlCommandNavigation)ni).setActive(false);
            if (ni.getChildCount() <= 0) continue;
            AbstractHtmlCommandNavigation.deactivateAllChildren(ni.getChildren().iterator());
        }
    }

    private static void closeAllChildren(Iterator children) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigation)) continue;
            ((HtmlCommandNavigation)ni).setOpen(false);
            if (ni.getChildCount() <= 0) continue;
            AbstractHtmlCommandNavigation.closeAllChildren(ni.getChildren().iterator());
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        ActionEvent actionEvent;
        if (event instanceof ActionEvent && (actionEvent = (ActionEvent)event).getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            HtmlCommandNavigation navItem = (HtmlCommandNavigation)actionEvent.getComponent();
            navItem.toggleOpen();
            FacesContext.getCurrentInstance().renderResponse();
        }
        super.broadcast(event);
    }
}

