/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class StatefulConverter implements Converter, StateHolder
{
    int count = 17;
    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException
    {
        ++count;
        return value.toUpperCase() + ":" + count;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException
    {
        ++count;
        if (value == null)
            return null;
        else
            return value.toString().toUpperCase() + ":" + count;
    }

    public boolean isTransient()
    {
        return false;
    }

    public void restoreState(FacesContext context, Object oldState)
    {
        Object[] state = (Object[]) oldState;
        count = ((Integer) state[0]).intValue();
    }

    public Object saveState(FacesContext context)
    {
        Object[] state = new Object[1];
        state[0] = new Integer(count);
        return state;
    }

    public void setTransient(boolean newTransientValue)
    {
    }
}
