/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.orchestra.viewController.ViewControllerNameMapper;

public class DefaultViewControllerNameMapper
implements ViewControllerNameMapper {
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("applicationScope", "cookie", "facesContext", "header", "headerValues", "initParam", "param", "paramValues", "requestScope", "sessionScope", "view"));

    public String mapViewId(String viewId) {
        String beanName;
        if (viewId == null) {
            return null;
        }
        boolean nextUpper = false;
        StringBuffer sb = new StringBuffer(viewId);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '/') {
                if (i > 0) {
                    nextUpper = true;
                }
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c == '.') {
                sb.delete(i, sb.length());
                break;
            }
            if (!nextUpper) continue;
            sb.setCharAt(i, Character.toUpperCase(c));
            nextUpper = false;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        if (RESERVED_WORDS.contains(beanName = sb.toString())) {
            return "_" + beanName;
        }
        if (beanName.length() > 0 && Character.isDigit(beanName.charAt(0))) {
            return "_" + beanName;
        }
        return beanName;
    }
}

