/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class EnumConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "jakarta.faces.Enum";
    public static final String ENUM_ID = "jakarta.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "jakarta.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private static final String ALLOW_STRING_PASSTROUGH = "org.apache.myfaces.ENUM_CONVERTER_ALLOW_STRING_PASSTROUGH";
    private Class targetClass;
    private boolean isTransient = false;
    private boolean _initialStateMarked = false;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        if (!targetClass.isEnum()) {
            throw new IllegalArgumentException("targetClass for EnumConverter must be an Enum");
        }
        this.targetClass = targetClass;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        this.checkTargetClass(facesContext, uiComponent, value);
        if (value == null) {
            return "";
        }
        if (value instanceof String && this._isPassThroughStringValues(facesContext)) {
            return (String)value;
        }
        if (this.targetClass.isInstance(value)) {
            return ((Enum)value).name();
        }
        Object[] params = new Object[]{value, this.firstConstantOfEnum(), MessageUtils.getLabel(facesContext, uiComponent)};
        throw new ConverterException(MessageUtils.getErrorMessage(facesContext, ENUM_ID, params));
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        this.checkTargetClass(facesContext, uiComponent, value);
        try {
            return Enum.valueOf(this.targetClass, value);
        }
        catch (IllegalArgumentException e) {
            Object[] params = new Object[]{value, this.firstConstantOfEnum(), MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, ENUM_ID, params));
        }
    }

    private void checkTargetClass(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (this.targetClass == null) {
            Object[] params = new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, ENUM_NO_CLASS_ID, params));
        }
    }

    private String firstConstantOfEnum() {
        T[] enumConstants = this.targetClass.getEnumConstants();
        if (enumConstants.length != 0) {
            return enumConstants[0].toString();
        }
        return "";
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            this.targetClass = (Class)state;
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            return this.targetClass;
        }
        return null;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    private boolean _isPassThroughStringValues(FacesContext facesContext) {
        String param = facesContext.getExternalContext().getInitParameter(ALLOW_STRING_PASSTROUGH);
        if (param != null) {
            return param.trim().equalsIgnoreCase("true");
        }
        return false;
    }
}

