/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletRequest;
import java.util.Map;

public class ViewNamespaceUtils {
    protected static final String CACHE_ATTR = "myfaces.viewnamespace";

    public static String getViewNamespace(FacesContext context) {
        return ViewNamespaceUtils.getViewNamespace(context, (ServletRequest)context.getExternalContext().getRequest());
    }

    public static String getViewNamespace(FacesContext context, ServletRequest request) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            if (context.getAttributes().containsKey(CACHE_ATTR)) {
                return (String)context.getAttributes().get(CACHE_ATTR);
            }
            Map requestParameterMap = request.getParameterMap();
            String viewNamespace = "";
            if (!requestParameterMap.containsKey("jakarta.faces.ViewState")) {
                viewNamespace = ViewNamespaceUtils.resolvePrefixFromRequest(context, requestParameterMap);
            }
            context.getAttributes().put(CACHE_ATTR, viewNamespace);
            return viewNamespace;
        }
        if (viewRoot instanceof NamingContainer) {
            return viewRoot.getContainerClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        }
        return "";
    }

    protected static String resolvePrefixFromRequest(FacesContext facesContext, Map<String, String[]> requestParameterMap) {
        Object firstViewStateKey = requestParameterMap.keySet().stream().filter(item -> item.contains("jakarta.faces.ViewState")).findFirst().orElse("");
        if (!((String)firstViewStateKey).isEmpty()) {
            char sep = facesContext.getNamingContainerSeparatorChar();
            firstViewStateKey = ((String)firstViewStateKey).split(String.valueOf(sep))[0] + sep;
        }
        return firstViewStateKey;
    }
}

