/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.util.Map;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

public abstract class AbstractContext
implements Context {
    private boolean passivatingScope;

    protected AbstractContext(BeanManager beanManager) {
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected abstract ContextualStorage getContextualStorage(boolean var1);

    public boolean isPassivatingScope() {
        return this.passivatingScope;
    }

    public <T> T get(Contextual<T> bean) {
        this.checkActive();
        ContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        this.checkActive();
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        ContextualStorage storage = this.getContextualStorage(true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        ContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public void destroyAllActive() {
        ContextualStorage storage = this.getContextualStorage(false);
        if (storage == null) {
            return;
        }
        AbstractContext.destroyAllActive(storage);
    }

    public static void destroyAllActive(ContextualStorage storage) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
    }

    protected void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

