/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.view.facelets.compiler.UILeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckDuplicateIdFaceletUtils {
    public static void checkIdsStatefulComponents(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, view, new HashSet<String>());
    }

    private static void checkIdsStatefulComponents(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (existingIds.contains(id)) {
            throw new IllegalStateException("component with duplicate id \"" + id + "\" found");
        }
        existingIds.add(id);
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                if (facet instanceof UILeaf) continue;
                CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = component.getChildren().get(i);
            if (child instanceof UILeaf) continue;
            CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, child, existingIds);
        }
    }

    public static void checkIds(FacesContext context, UIComponent view) {
        CheckDuplicateIdFaceletUtils.checkIds(context, view, new HashSet<String>());
    }

    private static void checkIds(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (existingIds.contains(id)) {
            throw new IllegalStateException("component with duplicate id \"" + id + "\" found");
        }
        existingIds.add(id);
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                CheckDuplicateIdFaceletUtils.checkIds(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = component.getChildren().get(i);
            CheckDuplicateIdFaceletUtils.checkIds(context, child, existingIds);
        }
    }
}

