/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.faces.view.facelets.ValidatorConfig;
import javax.faces.view.facelets.ValidatorHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerFactory;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.UserTagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagLibrary
implements TagLibrary {
    private final Map<String, TagHandlerFactory> _factories;
    private final Map<String, Method> _functions;
    private final String _namespace;

    public AbstractTagLibrary(String namespace) {
        this._namespace = namespace;
        this._factories = new HashMap<String, TagHandlerFactory>();
        this._functions = new HashMap<String, Method>();
    }

    @Override
    public boolean containsNamespace(String ns) {
        return this._namespace.equals(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        return this.containsNamespace(ns) && this._factories.containsKey(localName);
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        TagHandlerFactory f;
        if (this.containsNamespace(ns) && (f = this._factories.get(localName)) != null) {
            return f.createHandler(tag);
        }
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return this.containsNamespace(ns) && this._functions.containsKey(name);
    }

    @Override
    public Method createFunction(String ns, String name) {
        return this.containsNamespace(ns) ? this._functions.get(name) : null;
    }

    public String getNamespace() {
        return this._namespace;
    }

    protected final void addComponent(String name, String componentType, String rendererType) {
        this._factories.put(name, new ComponentHandlerFactory(componentType, rendererType));
    }

    protected final void addComponent(String name, String componentType, String rendererType, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new UserComponentHandlerFactory(componentType, rendererType, handlerType));
    }

    protected final void addConverter(String name, String converterId) {
        this._factories.put(name, new ConverterHandlerFactory(converterId));
    }

    protected final void addConverter(String name, String converterId, Class<? extends TagHandler> type) {
        this._factories.put(name, new UserConverterHandlerFactory(converterId, type));
    }

    protected final void addValidator(String name, String validatorId) {
        this._factories.put(name, new ValidatorHandlerFactory(validatorId));
    }

    protected final void addValidator(String name, String validatorId, Class<? extends TagHandler> type) {
        this._factories.put(name, new UserValidatorHandlerFactory(validatorId, type));
    }

    protected final void addTagHandler(String name, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new HandlerFactory(handlerType));
    }

    protected final void addUserTag(String name, URL source) {
        this._factories.put(name, new UserTagFactory(source));
    }

    protected final void addFunction(String name, Method method) {
        this._functions.put(name, method);
    }

    protected final void addBehavior(String name, String behaviorId) {
        this._factories.put(name, new BehaviorHandlerFactory(behaviorId));
    }

    protected final void addBehavior(String name, String behaviorId, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new UserBehaviorHandlerFactory(behaviorId, handlerType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserBehaviorHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{BehaviorConfig.class};
        protected final String behaviorId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserBehaviorHandlerFactory(String behaviorId, Class<? extends TagHandler> type) {
            this.behaviorId = behaviorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a BehaviorConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                BehaviorConfigWrapper bcfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
                return this.constructor.newInstance(bcfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating BehaviorHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class BehaviorHandlerFactory
    implements TagHandlerFactory {
        protected final String behaviorId;

        public BehaviorHandlerFactory(String behaviorId) {
            this.behaviorId = behaviorId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            BehaviorConfigWrapper bcfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
            return new BehaviorHandler((BehaviorConfig)bcfg);
        }
    }

    private static class BehaviorConfigWrapper
    implements BehaviorConfig {
        protected final TagConfig parent;
        protected final String behaviorId;

        public BehaviorConfigWrapper(TagConfig parent, String behaviorId) {
            this.parent = parent;
            this.behaviorId = behaviorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserValidatorHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ValidatorConfig.class};
        protected final String validatorId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserValidatorHandlerFactory(String validatorId, Class<? extends TagHandler> type) {
            this.validatorId = validatorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ValidatorConfigWrapper ccfg = new ValidatorConfigWrapper(cfg, this.validatorId);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ValidatorHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserConverterHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ConverterConfig.class};
        protected final String converterId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserConverterHandlerFactory(String converterId, Class<? extends TagHandler> type) {
            this.converterId = converterId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ConverterConfigWrapper ccfg = new ConverterConfigWrapper(cfg, this.converterId);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ConverterHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class ConverterHandlerFactory
    implements TagHandlerFactory {
        protected final String converterId;

        public ConverterHandlerFactory(String converterId) {
            this.converterId = converterId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ConverterHandler((ConverterConfig)new ConverterConfigWrapper(cfg, this.converterId));
        }
    }

    private static class ValidatorHandlerFactory
    implements TagHandlerFactory {
        protected final String validatorId;

        public ValidatorHandlerFactory(String validatorId) {
            this.validatorId = validatorId;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ValidatorHandler((ValidatorConfig)new ValidatorConfigWrapper(cfg, this.validatorId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserComponentHandlerFactory(String componentType, String renderType, Class<? extends TagHandler> type) {
            this.componentType = componentType;
            this.renderType = renderType;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", (Throwable)e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), (Throwable)e);
            }
        }
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String componentType, String renderType) {
            this.componentType = componentType;
            this.renderType = renderType;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
            return new ComponentHandler((ComponentConfig)ccfg);
        }
    }

    private static class UserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public UserTagFactory(URL location) {
            this.location = location;
        }

        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new UserTagHandler(cfg, this.location);
        }
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONSTRUCTOR_SIG = new Class[]{TagConfig.class};
        protected final Class<? extends TagHandler> handlerType;

        public HandlerFactory(Class<? extends TagHandler> handlerType) {
            this.handlerType = handlerType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                return this.handlerType.getConstructor(CONSTRUCTOR_SIG).newInstance(cfg);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof FacesException) {
                    throw (FacesException)t;
                }
                if (t instanceof ELException) {
                    throw (ELException)t;
                }
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), t);
            }
            catch (Exception e) {
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), (Throwable)e);
            }
        }
    }

    private static class ConverterConfigWrapper
    implements ConverterConfig {
        private final TagConfig parent;
        private final String converterId;

        public ConverterConfigWrapper(TagConfig parent, String converterId) {
            this.parent = parent;
            this.converterId = converterId;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ValidatorConfigWrapper
    implements ValidatorConfig {
        private final TagConfig parent;
        private final String validatorId;

        public ValidatorConfigWrapper(TagConfig parent, String validatorId) {
            this.parent = parent;
            this.validatorId = validatorId;
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

