/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class SheetPropertiesRecord
extends Record {
    public static final short sid = 4164;
    private short field_1_flags;
    private BitField chartTypeManuallyFormatted = new BitField(1);
    private BitField plotVisibleOnly = new BitField(2);
    private BitField doNotSizeWithWindow = new BitField(4);
    private BitField defaultPlotDimensions = new BitField(8);
    private BitField autoPlotArea = new BitField(16);
    private byte field_2_empty;
    public static final byte EMPTY_NOT_PLOTTED = 0;
    public static final byte EMPTY_ZERO = 1;
    public static final byte EMPTY_INTERPOLATED = 2;

    public SheetPropertiesRecord() {
    }

    public SheetPropertiesRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public SheetPropertiesRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4164) {
            throw new RecordFormatException("Not a SheetProperties record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_flags = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_empty = data[pos + 2 + offset];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SHTPROPS]\n");
        buffer.append("    .flags                = ").append("0x").append(HexDump.toHex(this.getFlags())).append(" (").append(this.getFlags()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .chartTypeManuallyFormatted     = ").append(this.isChartTypeManuallyFormatted()).append('\n');
        buffer.append("         .plotVisibleOnly          = ").append(this.isPlotVisibleOnly()).append('\n');
        buffer.append("         .doNotSizeWithWindow      = ").append(this.isDoNotSizeWithWindow()).append('\n');
        buffer.append("         .defaultPlotDimensions     = ").append(this.isDefaultPlotDimensions()).append('\n');
        buffer.append("         .autoPlotArea             = ").append(this.isAutoPlotArea()).append('\n');
        buffer.append("    .empty                = ").append("0x").append(HexDump.toHex(this.getEmpty())).append(" (").append(this.getEmpty()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SHTPROPS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4164);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_flags);
        data[6 + offset + pos] = this.field_2_empty;
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 7;
    }

    public short getSid() {
        return 4164;
    }

    public Object clone() {
        SheetPropertiesRecord rec = new SheetPropertiesRecord();
        rec.field_1_flags = this.field_1_flags;
        rec.field_2_empty = this.field_2_empty;
        return rec;
    }

    public short getFlags() {
        return this.field_1_flags;
    }

    public void setFlags(short field_1_flags) {
        this.field_1_flags = field_1_flags;
    }

    public byte getEmpty() {
        return this.field_2_empty;
    }

    public void setEmpty(byte field_2_empty) {
        this.field_2_empty = field_2_empty;
    }

    public void setChartTypeManuallyFormatted(boolean value) {
        this.field_1_flags = this.chartTypeManuallyFormatted.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isChartTypeManuallyFormatted() {
        return this.chartTypeManuallyFormatted.isSet(this.field_1_flags);
    }

    public void setPlotVisibleOnly(boolean value) {
        this.field_1_flags = this.plotVisibleOnly.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isPlotVisibleOnly() {
        return this.plotVisibleOnly.isSet(this.field_1_flags);
    }

    public void setDoNotSizeWithWindow(boolean value) {
        this.field_1_flags = this.doNotSizeWithWindow.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isDoNotSizeWithWindow() {
        return this.doNotSizeWithWindow.isSet(this.field_1_flags);
    }

    public void setDefaultPlotDimensions(boolean value) {
        this.field_1_flags = this.defaultPlotDimensions.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isDefaultPlotDimensions() {
        return this.defaultPlotDimensions.isSet(this.field_1_flags);
    }

    public void setAutoPlotArea(boolean value) {
        this.field_1_flags = this.autoPlotArea.setShortBoolean(this.field_1_flags, value);
    }

    public boolean isAutoPlotArea() {
        return this.autoPlotArea.isSet(this.field_1_flags);
    }
}

