/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Booleans {
    private static final Booleans INSTANCE = new Booleans();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Booleans instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Booleans() {
    }

    public void assertEqual(AssertionInfo info, Boolean actual, boolean expected) {
        Booleans.assertNotNull(info, actual);
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, info.representation()));
    }

    public void assertNotEqual(AssertionInfo info, Boolean actual, boolean other) {
        Booleans.assertNotNull(info, actual);
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    private static void assertNotNull(AssertionInfo info, Boolean actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

