/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceMapFactoryBean
extends PropertiesFactoryBean
implements ResourceLoaderAware {
    private String resourceBasePath = "";
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public void setResourceBasePath(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public Class getObjectType() {
        return Map.class;
    }

    protected Object createInstance() throws IOException {
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        Properties props = this.mergeProperties();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String location = props.getProperty(key);
            resourceMap.put(key, this.getResource(location));
        }
        return resourceMap;
    }

    protected Resource getResource(String location) {
        return this.resourceLoader.getResource(this.resourceBasePath + location);
    }
}

