/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slice
extends ZkNodeProps
implements Iterable<Replica> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final String collection;
    private final String name;
    private final DocRouter.Range range;
    private final Integer replicationFactor;
    private final Map<String, Replica> replicas;
    private final Replica leader;
    private final State state;
    private final String parent;
    private final Map<String, RoutingRule> routingRules;
    private final int numLeaderReplicas;

    public static Map<String, Slice> loadAllFromMap(String collection, Map<String, Object> genericSlices) {
        if (genericSlices == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Slice> result = new LinkedHashMap<String, Slice>(genericSlices.size());
        for (Map.Entry<String, Object> entry : genericSlices.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Slice) {
                result.put(name, (Slice)val);
                continue;
            }
            if (!(val instanceof Map)) continue;
            result.put(name, new Slice(name, null, (Map)val, collection));
        }
        return result;
    }

    @Override
    public Iterator<Replica> iterator() {
        return this.replicas.values().iterator();
    }

    public Slice copyWith(Replica modified) {
        if (log.isDebugEnabled()) {
            log.debug("modified replica : {}", (Object)modified);
        }
        LinkedHashMap<String, Replica> replicasCopy = new LinkedHashMap<String, Replica>(this.replicas);
        replicasCopy.put(modified.getName(), modified);
        return new Slice(this.name, replicasCopy, this.propMap, this.collection);
    }

    public Slice(String name, Map<String, Replica> replicas, Map<String, Object> props, String collection) {
        super(props == null ? new LinkedHashMap<String, Object>(2) : new LinkedHashMap<String, Object>(props));
        this.name = name;
        this.collection = collection;
        Object rangeObj = this.propMap.get("range");
        if (this.propMap.get("state") != null) {
            this.state = State.getState((String)this.propMap.get("state"));
        } else {
            this.state = State.ACTIVE;
            this.propMap.put("state", this.state.toString());
        }
        DocRouter.Range tmpRange = null;
        if (rangeObj instanceof DocRouter.Range) {
            tmpRange = (DocRouter.Range)rangeObj;
        } else if (rangeObj != null) {
            tmpRange = DocRouter.DEFAULT.fromString(rangeObj.toString());
        }
        this.range = tmpRange;
        this.parent = this.propMap.containsKey("parent") && this.propMap.get("parent") != null ? (String)this.propMap.get("parent") : null;
        this.replicationFactor = null;
        this.replicas = replicas != null ? replicas : this.makeReplicas(collection, name, (Map)this.propMap.get("replicas"));
        this.propMap.put("replicas", this.replicas);
        this.numLeaderReplicas = (int)this.replicas.values().stream().filter(r -> r.type.leaderEligible).count();
        Map rules = (Map)this.propMap.get("routingRules");
        if (rules != null) {
            this.routingRules = new HashMap<String, RoutingRule>();
            for (Map.Entry entry : rules.entrySet()) {
                Object o = entry.getValue();
                if (o instanceof Map) {
                    Map map = (Map)o;
                    RoutingRule rule = new RoutingRule((String)entry.getKey(), map);
                    this.routingRules.put((String)entry.getKey(), rule);
                    continue;
                }
                this.routingRules.put((String)entry.getKey(), (RoutingRule)o);
            }
        } else {
            this.routingRules = null;
        }
        this.leader = this.findLeader();
    }

    private Map<String, Replica> makeReplicas(String collection, String slice, Map<String, Object> genericReplicas) {
        if (genericReplicas == null) {
            return new HashMap<String, Replica>(1);
        }
        LinkedHashMap<String, Replica> result = new LinkedHashMap<String, Replica>(genericReplicas.size());
        for (Map.Entry<String, Object> entry : genericReplicas.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            Replica r = val instanceof Replica ? (Replica)val : new Replica(name, (Map)val, collection, slice);
            result.put(name, r);
        }
        return result;
    }

    private Replica findLeader() {
        for (Replica replica : this.replicas.values()) {
            if (!replica.isLeader()) continue;
            assert (replica.getType() == Replica.Type.TLOG || replica.getType() == Replica.Type.NRT) : "Pull replica should not become leader!";
            return replica;
        }
        return null;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Replica> getReplicas() {
        return this.replicas.values();
    }

    public Set<String> getReplicaNames() {
        return Collections.unmodifiableSet(this.replicas.keySet());
    }

    public List<Replica> getReplicas(Predicate<Replica> pred) {
        return this.replicas.values().stream().filter(pred).collect(Collectors.toList());
    }

    public List<Replica> getReplicas(EnumSet<Replica.Type> s) {
        return this.getReplicas((Replica r) -> s.contains((Object)r.getType()));
    }

    public Map<String, Replica> getReplicasMap() {
        return this.replicas;
    }

    public Map<String, Replica> getReplicasCopy() {
        return new LinkedHashMap<String, Replica>(this.replicas);
    }

    public Replica getLeader() {
        return this.leader;
    }

    public int getNumLeaderReplicas() {
        return this.numLeaderReplicas;
    }

    public Replica getReplica(String replicaName) {
        return this.replicas.get(replicaName);
    }

    public DocRouter.Range getRange() {
        return this.range;
    }

    public State getState() {
        return this.state;
    }

    public String getParent() {
        return this.parent;
    }

    public Map<String, RoutingRule> getRoutingRules() {
        return this.routingRules;
    }

    @Override
    public String toString() {
        return this.name + ":" + Utils.toJSONString(this.propMap);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }

    public static interface SliceStateProps {
        public static final String STATE_PROP = "state";
        public static final String REPLICAS = "replicas";
        public static final String RANGE = "range";
        public static final String LEADER = "leader";
        public static final String PARENT = "parent";
    }

    public static enum State {
        ACTIVE,
        INACTIVE,
        CONSTRUCTION,
        RECOVERY,
        RECOVERY_FAILED;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

