/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.api;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Fileable;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;

public interface ObjectStore {
    public Folder getRootFolder();

    public StoredObject getObjectByPath(String var1, String var2);

    public StoredObject getObjectById(String var1);

    public void deleteObject(String var1, Boolean var2, String var3);

    public Document createDocument(Map<String, PropertyData<?>> var1, String var2, Folder var3, ContentStream var4, List<String> var5, Acl var6, Acl var7);

    public Folder createFolder(String var1, Map<String, PropertyData<?>> var2, String var3, Folder var4, List<String> var5, Acl var6, Acl var7);

    public DocumentVersion createVersionedDocument(String var1, Map<String, PropertyData<?>> var2, String var3, Folder var4, List<String> var5, Acl var6, Acl var7, ContentStream var8, VersioningState var9);

    public StoredObject createItem(String var1, Map<String, PropertyData<?>> var2, String var3, Folder var4, List<String> var5, Acl var6, Acl var7);

    public StoredObject createPolicy(String var1, String var2, Map<String, PropertyData<?>> var3, String var4, Acl var5, Acl var6);

    public ChildrenResult getChildren(Folder var1, int var2, int var3, String var4, boolean var5);

    public ChildrenResult getFolderChildren(Folder var1, int var2, int var3, String var4);

    public void move(StoredObject var1, Folder var2, Folder var3, String var4);

    public void rename(StoredObject var1, String var2, String var3);

    public void storeVersion(DocumentVersion var1);

    public void deleteVersion(DocumentVersion var1);

    public void updateObject(StoredObject var1, Map<String, PropertyData<?>> var2, String var3);

    public String getFolderPath(String var1);

    public void clear();

    public long getObjectCount();

    public StoredObject createRelationship(String var1, StoredObject var2, StoredObject var3, Map<String, PropertyData<?>> var4, String var5, Acl var6, Acl var7);

    public List<StoredObject> getCheckedOutDocuments(String var1, String var2, IncludeRelationships var3);

    public Acl applyAcl(StoredObject var1, Acl var2, Acl var3, AclPropagation var4, String var5);

    public Acl applyAcl(StoredObject var1, Acl var2, AclPropagation var3, String var4);

    public boolean isTypeInUse(String var1);

    public List<StoredObject> getRelationships(String var1, List<String> var2, RelationshipDirection var3);

    public Acl getAcl(int var1);

    public List<String> getParentIds(StoredObject var1, String var2);

    public void addParent(StoredObject var1, Folder var2);

    public void removeParent(StoredObject var1, Folder var2);

    public ContentStream getContent(StoredObject var1, long var2, long var4);

    public ContentStream setContent(StoredObject var1, ContentStream var2);

    public void appendContent(StoredObject var1, ContentStream var2);

    public List<RenditionData> getRenditions(StoredObject var1, String var2, long var3, long var5);

    public ContentStream getRenditionContent(StoredObject var1, String var2, long var3, long var5);

    public static class ChildrenResult {
        private int noItems;
        private List<Fileable> children;

        public ChildrenResult(List<Fileable> children, int noItems) {
            this.children = children;
            this.noItems = noItems;
        }

        public int getNoItems() {
            return this.noItems;
        }

        public List<Fileable> getChildren() {
            return this.children;
        }
    }
}

