﻿/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class BasqueStemmer : SnowballProgram
    {
        private readonly static BasqueStemmer methodObject = new BasqueStemmer();

        private readonly static Among[] a_0 = {
                    new Among ( "idea", -1, 1, "", methodObject ),
                    new Among ( "bidea", 0, 1, "", methodObject ),
                    new Among ( "kidea", 0, 1, "", methodObject ),
                    new Among ( "pidea", 0, 1, "", methodObject ),
                    new Among ( "kundea", -1, 1, "", methodObject ),
                    new Among ( "galea", -1, 1, "", methodObject ),
                    new Among ( "tailea", -1, 1, "", methodObject ),
                    new Among ( "tzailea", -1, 1, "", methodObject ),
                    new Among ( "gunea", -1, 1, "", methodObject ),
                    new Among ( "kunea", -1, 1, "", methodObject ),
                    new Among ( "tzaga", -1, 1, "", methodObject ),
                    new Among ( "gaia", -1, 1, "", methodObject ),
                    new Among ( "aldia", -1, 1, "", methodObject ),
                    new Among ( "taldia", 12, 1, "", methodObject ),
                    new Among ( "karia", -1, 1, "", methodObject ),
                    new Among ( "garria", -1, 2, "", methodObject ),
                    new Among ( "karria", -1, 1, "", methodObject ),
                    new Among ( "ka", -1, 1, "", methodObject ),
                    new Among ( "tzaka", 17, 1, "", methodObject ),
                    new Among ( "la", -1, 1, "", methodObject ),
                    new Among ( "mena", -1, 1, "", methodObject ),
                    new Among ( "pena", -1, 1, "", methodObject ),
                    new Among ( "kina", -1, 1, "", methodObject ),
                    new Among ( "ezina", -1, 1, "", methodObject ),
                    new Among ( "tezina", 23, 1, "", methodObject ),
                    new Among ( "kuna", -1, 1, "", methodObject ),
                    new Among ( "tuna", -1, 1, "", methodObject ),
                    new Among ( "kizuna", -1, 1, "", methodObject ),
                    new Among ( "era", -1, 1, "", methodObject ),
                    new Among ( "bera", 28, 1, "", methodObject ),
                    new Among ( "arabera", 29, 4, "", methodObject ),
                    new Among ( "kera", 28, 1, "", methodObject ),
                    new Among ( "pera", 28, 1, "", methodObject ),
                    new Among ( "orra", -1, 1, "", methodObject ),
                    new Among ( "korra", 33, 1, "", methodObject ),
                    new Among ( "dura", -1, 1, "", methodObject ),
                    new Among ( "gura", -1, 1, "", methodObject ),
                    new Among ( "kura", -1, 1, "", methodObject ),
                    new Among ( "tura", -1, 1, "", methodObject ),
                    new Among ( "eta", -1, 1, "", methodObject ),
                    new Among ( "keta", 39, 1, "", methodObject ),
                    new Among ( "gailua", -1, 1, "", methodObject ),
                    new Among ( "eza", -1, 1, "", methodObject ),
                    new Among ( "erreza", 42, 1, "", methodObject ),
                    new Among ( "tza", -1, 2, "", methodObject ),
                    new Among ( "gaitza", 44, 1, "", methodObject ),
                    new Among ( "kaitza", 44, 1, "", methodObject ),
                    new Among ( "kuntza", 44, 1, "", methodObject ),
                    new Among ( "ide", -1, 1, "", methodObject ),
                    new Among ( "bide", 48, 1, "", methodObject ),
                    new Among ( "kide", 48, 1, "", methodObject ),
                    new Among ( "pide", 48, 1, "", methodObject ),
                    new Among ( "kunde", -1, 1, "", methodObject ),
                    new Among ( "tzake", -1, 1, "", methodObject ),
                    new Among ( "tzeke", -1, 1, "", methodObject ),
                    new Among ( "le", -1, 1, "", methodObject ),
                    new Among ( "gale", 55, 1, "", methodObject ),
                    new Among ( "taile", 55, 1, "", methodObject ),
                    new Among ( "tzaile", 55, 1, "", methodObject ),
                    new Among ( "gune", -1, 1, "", methodObject ),
                    new Among ( "kune", -1, 1, "", methodObject ),
                    new Among ( "tze", -1, 1, "", methodObject ),
                    new Among ( "atze", 61, 1, "", methodObject ),
                    new Among ( "gai", -1, 1, "", methodObject ),
                    new Among ( "aldi", -1, 1, "", methodObject ),
                    new Among ( "taldi", 64, 1, "", methodObject ),
                    new Among ( "ki", -1, 1, "", methodObject ),
                    new Among ( "ari", -1, 1, "", methodObject ),
                    new Among ( "kari", 67, 1, "", methodObject ),
                    new Among ( "lari", 67, 1, "", methodObject ),
                    new Among ( "tari", 67, 1, "", methodObject ),
                    new Among ( "etari", 70, 1, "", methodObject ),
                    new Among ( "garri", -1, 2, "", methodObject ),
                    new Among ( "karri", -1, 1, "", methodObject ),
                    new Among ( "arazi", -1, 1, "", methodObject ),
                    new Among ( "tarazi", 74, 1, "", methodObject ),
                    new Among ( "an", -1, 1, "", methodObject ),
                    new Among ( "ean", 76, 1, "", methodObject ),
                    new Among ( "rean", 77, 1, "", methodObject ),
                    new Among ( "kan", 76, 1, "", methodObject ),
                    new Among ( "etan", 76, 1, "", methodObject ),
                    new Among ( "atseden", -1, 3, "", methodObject ),
                    new Among ( "men", -1, 1, "", methodObject ),
                    new Among ( "pen", -1, 1, "", methodObject ),
                    new Among ( "kin", -1, 1, "", methodObject ),
                    new Among ( "rekin", 84, 1, "", methodObject ),
                    new Among ( "ezin", -1, 1, "", methodObject ),
                    new Among ( "tezin", 86, 1, "", methodObject ),
                    new Among ( "tun", -1, 1, "", methodObject ),
                    new Among ( "kizun", -1, 1, "", methodObject ),
                    new Among ( "go", -1, 1, "", methodObject ),
                    new Among ( "ago", 90, 1, "", methodObject ),
                    new Among ( "tio", -1, 1, "", methodObject ),
                    new Among ( "dako", -1, 1, "", methodObject ),
                    new Among ( "or", -1, 1, "", methodObject ),
                    new Among ( "kor", 94, 1, "", methodObject ),
                    new Among ( "tzat", -1, 1, "", methodObject ),
                    new Among ( "du", -1, 1, "", methodObject ),
                    new Among ( "gailu", -1, 1, "", methodObject ),
                    new Among ( "tu", -1, 1, "", methodObject ),
                    new Among ( "atu", 99, 1, "", methodObject ),
                    new Among ( "aldatu", 100, 1, "", methodObject ),
                    new Among ( "tatu", 100, 1, "", methodObject ),
                    new Among ( "baditu", 99, 5, "", methodObject ),
                    new Among ( "ez", -1, 1, "", methodObject ),
                    new Among ( "errez", 104, 1, "", methodObject ),
                    new Among ( "tzez", 104, 1, "", methodObject ),
                    new Among ( "gaitz", -1, 1, "", methodObject ),
                    new Among ( "kaitz", -1, 1, "", methodObject )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "ada", -1, 1, "", methodObject ),
                    new Among ( "kada", 0, 1, "", methodObject ),
                    new Among ( "anda", -1, 1, "", methodObject ),
                    new Among ( "denda", -1, 1, "", methodObject ),
                    new Among ( "gabea", -1, 1, "", methodObject ),
                    new Among ( "kabea", -1, 1, "", methodObject ),
                    new Among ( "aldea", -1, 1, "", methodObject ),
                    new Among ( "kaldea", 6, 1, "", methodObject ),
                    new Among ( "taldea", 6, 1, "", methodObject ),
                    new Among ( "ordea", -1, 1, "", methodObject ),
                    new Among ( "zalea", -1, 1, "", methodObject ),
                    new Among ( "tzalea", 10, 1, "", methodObject ),
                    new Among ( "gilea", -1, 1, "", methodObject ),
                    new Among ( "emea", -1, 1, "", methodObject ),
                    new Among ( "kumea", -1, 1, "", methodObject ),
                    new Among ( "nea", -1, 1, "", methodObject ),
                    new Among ( "enea", 15, 1, "", methodObject ),
                    new Among ( "zionea", 15, 1, "", methodObject ),
                    new Among ( "unea", 15, 1, "", methodObject ),
                    new Among ( "gunea", 18, 1, "", methodObject ),
                    new Among ( "pea", -1, 1, "", methodObject ),
                    new Among ( "aurrea", -1, 1, "", methodObject ),
                    new Among ( "tea", -1, 1, "", methodObject ),
                    new Among ( "kotea", 22, 1, "", methodObject ),
                    new Among ( "artea", 22, 1, "", methodObject ),
                    new Among ( "ostea", 22, 1, "", methodObject ),
                    new Among ( "etxea", -1, 1, "", methodObject ),
                    new Among ( "ga", -1, 1, "", methodObject ),
                    new Among ( "anga", 27, 1, "", methodObject ),
                    new Among ( "gaia", -1, 1, "", methodObject ),
                    new Among ( "aldia", -1, 1, "", methodObject ),
                    new Among ( "taldia", 30, 1, "", methodObject ),
                    new Among ( "handia", -1, 1, "", methodObject ),
                    new Among ( "mendia", -1, 1, "", methodObject ),
                    new Among ( "geia", -1, 1, "", methodObject ),
                    new Among ( "egia", -1, 1, "", methodObject ),
                    new Among ( "degia", 35, 1, "", methodObject ),
                    new Among ( "tegia", 35, 1, "", methodObject ),
                    new Among ( "nahia", -1, 1, "", methodObject ),
                    new Among ( "ohia", -1, 1, "", methodObject ),
                    new Among ( "kia", -1, 1, "", methodObject ),
                    new Among ( "tokia", 40, 1, "", methodObject ),
                    new Among ( "oia", -1, 1, "", methodObject ),
                    new Among ( "koia", 42, 1, "", methodObject ),
                    new Among ( "aria", -1, 1, "", methodObject ),
                    new Among ( "karia", 44, 1, "", methodObject ),
                    new Among ( "laria", 44, 1, "", methodObject ),
                    new Among ( "taria", 44, 1, "", methodObject ),
                    new Among ( "eria", -1, 1, "", methodObject ),
                    new Among ( "keria", 48, 1, "", methodObject ),
                    new Among ( "teria", 48, 1, "", methodObject ),
                    new Among ( "garria", -1, 2, "", methodObject ),
                    new Among ( "larria", -1, 1, "", methodObject ),
                    new Among ( "kirria", -1, 1, "", methodObject ),
                    new Among ( "duria", -1, 1, "", methodObject ),
                    new Among ( "asia", -1, 1, "", methodObject ),
                    new Among ( "tia", -1, 1, "", methodObject ),
                    new Among ( "ezia", -1, 1, "", methodObject ),
                    new Among ( "bizia", -1, 1, "", methodObject ),
                    new Among ( "ontzia", -1, 1, "", methodObject ),
                    new Among ( "ka", -1, 1, "", methodObject ),
                    new Among ( "joka", 60, 3, "", methodObject ),
                    new Among ( "aurka", 60, 10, "", methodObject ),
                    new Among ( "ska", 60, 1, "", methodObject ),
                    new Among ( "xka", 60, 1, "", methodObject ),
                    new Among ( "zka", 60, 1, "", methodObject ),
                    new Among ( "gibela", -1, 1, "", methodObject ),
                    new Among ( "gela", -1, 1, "", methodObject ),
                    new Among ( "kaila", -1, 1, "", methodObject ),
                    new Among ( "skila", -1, 1, "", methodObject ),
                    new Among ( "tila", -1, 1, "", methodObject ),
                    new Among ( "ola", -1, 1, "", methodObject ),
                    new Among ( "na", -1, 1, "", methodObject ),
                    new Among ( "kana", 72, 1, "", methodObject ),
                    new Among ( "ena", 72, 1, "", methodObject ),
                    new Among ( "garrena", 74, 1, "", methodObject ),
                    new Among ( "gerrena", 74, 1, "", methodObject ),
                    new Among ( "urrena", 74, 1, "", methodObject ),
                    new Among ( "zaina", 72, 1, "", methodObject ),
                    new Among ( "tzaina", 78, 1, "", methodObject ),
                    new Among ( "kina", 72, 1, "", methodObject ),
                    new Among ( "mina", 72, 1, "", methodObject ),
                    new Among ( "garna", 72, 1, "", methodObject ),
                    new Among ( "una", 72, 1, "", methodObject ),
                    new Among ( "duna", 83, 1, "", methodObject ),
                    new Among ( "asuna", 83, 1, "", methodObject ),
                    new Among ( "tasuna", 85, 1, "", methodObject ),
                    new Among ( "ondoa", -1, 1, "", methodObject ),
                    new Among ( "kondoa", 87, 1, "", methodObject ),
                    new Among ( "ngoa", -1, 1, "", methodObject ),
                    new Among ( "zioa", -1, 1, "", methodObject ),
                    new Among ( "koa", -1, 1, "", methodObject ),
                    new Among ( "takoa", 91, 1, "", methodObject ),
                    new Among ( "zkoa", 91, 1, "", methodObject ),
                    new Among ( "noa", -1, 1, "", methodObject ),
                    new Among ( "zinoa", 94, 1, "", methodObject ),
                    new Among ( "aroa", -1, 1, "", methodObject ),
                    new Among ( "taroa", 96, 1, "", methodObject ),
                    new Among ( "zaroa", 96, 1, "", methodObject ),
                    new Among ( "eroa", -1, 1, "", methodObject ),
                    new Among ( "oroa", -1, 1, "", methodObject ),
                    new Among ( "osoa", -1, 1, "", methodObject ),
                    new Among ( "toa", -1, 1, "", methodObject ),
                    new Among ( "ttoa", 102, 1, "", methodObject ),
                    new Among ( "ztoa", 102, 1, "", methodObject ),
                    new Among ( "txoa", -1, 1, "", methodObject ),
                    new Among ( "tzoa", -1, 1, "", methodObject ),
                    new Among ( "\u00F1oa", -1, 1, "", methodObject ),
                    new Among ( "ra", -1, 1, "", methodObject ),
                    new Among ( "ara", 108, 1, "", methodObject ),
                    new Among ( "dara", 109, 1, "", methodObject ),
                    new Among ( "liara", 109, 1, "", methodObject ),
                    new Among ( "tiara", 109, 1, "", methodObject ),
                    new Among ( "tara", 109, 1, "", methodObject ),
                    new Among ( "etara", 113, 1, "", methodObject ),
                    new Among ( "tzara", 109, 1, "", methodObject ),
                    new Among ( "bera", 108, 1, "", methodObject ),
                    new Among ( "kera", 108, 1, "", methodObject ),
                    new Among ( "pera", 108, 1, "", methodObject ),
                    new Among ( "ora", 108, 2, "", methodObject ),
                    new Among ( "tzarra", 108, 1, "", methodObject ),
                    new Among ( "korra", 108, 1, "", methodObject ),
                    new Among ( "tra", 108, 1, "", methodObject ),
                    new Among ( "sa", -1, 1, "", methodObject ),
                    new Among ( "osa", 123, 1, "", methodObject ),
                    new Among ( "ta", -1, 1, "", methodObject ),
                    new Among ( "eta", 125, 1, "", methodObject ),
                    new Among ( "keta", 126, 1, "", methodObject ),
                    new Among ( "sta", 125, 1, "", methodObject ),
                    new Among ( "dua", -1, 1, "", methodObject ),
                    new Among ( "mendua", 129, 1, "", methodObject ),
                    new Among ( "ordua", 129, 1, "", methodObject ),
                    new Among ( "lekua", -1, 1, "", methodObject ),
                    new Among ( "burua", -1, 1, "", methodObject ),
                    new Among ( "durua", -1, 1, "", methodObject ),
                    new Among ( "tsua", -1, 1, "", methodObject ),
                    new Among ( "tua", -1, 1, "", methodObject ),
                    new Among ( "mentua", 136, 1, "", methodObject ),
                    new Among ( "estua", 136, 1, "", methodObject ),
                    new Among ( "txua", -1, 1, "", methodObject ),
                    new Among ( "zua", -1, 1, "", methodObject ),
                    new Among ( "tzua", 140, 1, "", methodObject ),
                    new Among ( "za", -1, 1, "", methodObject ),
                    new Among ( "eza", 142, 1, "", methodObject ),
                    new Among ( "eroza", 142, 1, "", methodObject ),
                    new Among ( "tza", 142, 2, "", methodObject ),
                    new Among ( "koitza", 145, 1, "", methodObject ),
                    new Among ( "antza", 145, 1, "", methodObject ),
                    new Among ( "gintza", 145, 1, "", methodObject ),
                    new Among ( "kintza", 145, 1, "", methodObject ),
                    new Among ( "kuntza", 145, 1, "", methodObject ),
                    new Among ( "gabe", -1, 1, "", methodObject ),
                    new Among ( "kabe", -1, 1, "", methodObject ),
                    new Among ( "kide", -1, 1, "", methodObject ),
                    new Among ( "alde", -1, 1, "", methodObject ),
                    new Among ( "kalde", 154, 1, "", methodObject ),
                    new Among ( "talde", 154, 1, "", methodObject ),
                    new Among ( "orde", -1, 1, "", methodObject ),
                    new Among ( "ge", -1, 1, "", methodObject ),
                    new Among ( "zale", -1, 1, "", methodObject ),
                    new Among ( "tzale", 159, 1, "", methodObject ),
                    new Among ( "gile", -1, 1, "", methodObject ),
                    new Among ( "eme", -1, 1, "", methodObject ),
                    new Among ( "kume", -1, 1, "", methodObject ),
                    new Among ( "ne", -1, 1, "", methodObject ),
                    new Among ( "zione", 164, 1, "", methodObject ),
                    new Among ( "une", 164, 1, "", methodObject ),
                    new Among ( "gune", 166, 1, "", methodObject ),
                    new Among ( "pe", -1, 1, "", methodObject ),
                    new Among ( "aurre", -1, 1, "", methodObject ),
                    new Among ( "te", -1, 1, "", methodObject ),
                    new Among ( "kote", 170, 1, "", methodObject ),
                    new Among ( "arte", 170, 1, "", methodObject ),
                    new Among ( "oste", 170, 1, "", methodObject ),
                    new Among ( "etxe", -1, 1, "", methodObject ),
                    new Among ( "gai", -1, 1, "", methodObject ),
                    new Among ( "di", -1, 1, "", methodObject ),
                    new Among ( "aldi", 176, 1, "", methodObject ),
                    new Among ( "taldi", 177, 1, "", methodObject ),
                    new Among ( "geldi", 176, 8, "", methodObject ),
                    new Among ( "handi", 176, 1, "", methodObject ),
                    new Among ( "mendi", 176, 1, "", methodObject ),
                    new Among ( "gei", -1, 1, "", methodObject ),
                    new Among ( "egi", -1, 1, "", methodObject ),
                    new Among ( "degi", 183, 1, "", methodObject ),
                    new Among ( "tegi", 183, 1, "", methodObject ),
                    new Among ( "nahi", -1, 1, "", methodObject ),
                    new Among ( "ohi", -1, 1, "", methodObject ),
                    new Among ( "ki", -1, 1, "", methodObject ),
                    new Among ( "toki", 188, 1, "", methodObject ),
                    new Among ( "oi", -1, 1, "", methodObject ),
                    new Among ( "goi", 190, 1, "", methodObject ),
                    new Among ( "koi", 190, 1, "", methodObject ),
                    new Among ( "ari", -1, 1, "", methodObject ),
                    new Among ( "kari", 193, 1, "", methodObject ),
                    new Among ( "lari", 193, 1, "", methodObject ),
                    new Among ( "tari", 193, 1, "", methodObject ),
                    new Among ( "garri", -1, 2, "", methodObject ),
                    new Among ( "larri", -1, 1, "", methodObject ),
                    new Among ( "kirri", -1, 1, "", methodObject ),
                    new Among ( "duri", -1, 1, "", methodObject ),
                    new Among ( "asi", -1, 1, "", methodObject ),
                    new Among ( "ti", -1, 1, "", methodObject ),
                    new Among ( "ontzi", -1, 1, "", methodObject ),
                    new Among ( "\u00F1i", -1, 1, "", methodObject ),
                    new Among ( "ak", -1, 1, "", methodObject ),
                    new Among ( "ek", -1, 1, "", methodObject ),
                    new Among ( "tarik", -1, 1, "", methodObject ),
                    new Among ( "gibel", -1, 1, "", methodObject ),
                    new Among ( "ail", -1, 1, "", methodObject ),
                    new Among ( "kail", 209, 1, "", methodObject ),
                    new Among ( "kan", -1, 1, "", methodObject ),
                    new Among ( "tan", -1, 1, "", methodObject ),
                    new Among ( "etan", 212, 1, "", methodObject ),
                    new Among ( "en", -1, 4, "", methodObject ),
                    new Among ( "ren", 214, 2, "", methodObject ),
                    new Among ( "garren", 215, 1, "", methodObject ),
                    new Among ( "gerren", 215, 1, "", methodObject ),
                    new Among ( "urren", 215, 1, "", methodObject ),
                    new Among ( "ten", 214, 4, "", methodObject ),
                    new Among ( "tzen", 214, 4, "", methodObject ),
                    new Among ( "zain", -1, 1, "", methodObject ),
                    new Among ( "tzain", 221, 1, "", methodObject ),
                    new Among ( "kin", -1, 1, "", methodObject ),
                    new Among ( "min", -1, 1, "", methodObject ),
                    new Among ( "dun", -1, 1, "", methodObject ),
                    new Among ( "asun", -1, 1, "", methodObject ),
                    new Among ( "tasun", 226, 1, "", methodObject ),
                    new Among ( "aizun", -1, 1, "", methodObject ),
                    new Among ( "ondo", -1, 1, "", methodObject ),
                    new Among ( "kondo", 229, 1, "", methodObject ),
                    new Among ( "go", -1, 1, "", methodObject ),
                    new Among ( "ngo", 231, 1, "", methodObject ),
                    new Among ( "zio", -1, 1, "", methodObject ),
                    new Among ( "ko", -1, 1, "", methodObject ),
                    new Among ( "trako", 234, 5, "", methodObject ),
                    new Among ( "tako", 234, 1, "", methodObject ),
                    new Among ( "etako", 236, 1, "", methodObject ),
                    new Among ( "eko", 234, 1, "", methodObject ),
                    new Among ( "tariko", 234, 1, "", methodObject ),
                    new Among ( "sko", 234, 1, "", methodObject ),
                    new Among ( "tuko", 234, 1, "", methodObject ),
                    new Among ( "minutuko", 241, 6, "", methodObject ),
                    new Among ( "zko", 234, 1, "", methodObject ),
                    new Among ( "no", -1, 1, "", methodObject ),
                    new Among ( "zino", 244, 1, "", methodObject ),
                    new Among ( "ro", -1, 1, "", methodObject ),
                    new Among ( "aro", 246, 1, "", methodObject ),
                    new Among ( "igaro", 247, 9, "", methodObject ),
                    new Among ( "taro", 247, 1, "", methodObject ),
                    new Among ( "zaro", 247, 1, "", methodObject ),
                    new Among ( "ero", 246, 1, "", methodObject ),
                    new Among ( "giro", 246, 1, "", methodObject ),
                    new Among ( "oro", 246, 1, "", methodObject ),
                    new Among ( "oso", -1, 1, "", methodObject ),
                    new Among ( "to", -1, 1, "", methodObject ),
                    new Among ( "tto", 255, 1, "", methodObject ),
                    new Among ( "zto", 255, 1, "", methodObject ),
                    new Among ( "txo", -1, 1, "", methodObject ),
                    new Among ( "tzo", -1, 1, "", methodObject ),
                    new Among ( "gintzo", 259, 1, "", methodObject ),
                    new Among ( "\u00F1o", -1, 1, "", methodObject ),
                    new Among ( "zp", -1, 1, "", methodObject ),
                    new Among ( "ar", -1, 1, "", methodObject ),
                    new Among ( "dar", 263, 1, "", methodObject ),
                    new Among ( "behar", 263, 1, "", methodObject ),
                    new Among ( "zehar", 263, 7, "", methodObject ),
                    new Among ( "liar", 263, 1, "", methodObject ),
                    new Among ( "tiar", 263, 1, "", methodObject ),
                    new Among ( "tar", 263, 1, "", methodObject ),
                    new Among ( "tzar", 263, 1, "", methodObject ),
                    new Among ( "or", -1, 2, "", methodObject ),
                    new Among ( "kor", 271, 1, "", methodObject ),
                    new Among ( "os", -1, 1, "", methodObject ),
                    new Among ( "ket", -1, 1, "", methodObject ),
                    new Among ( "du", -1, 1, "", methodObject ),
                    new Among ( "mendu", 275, 1, "", methodObject ),
                    new Among ( "ordu", 275, 1, "", methodObject ),
                    new Among ( "leku", -1, 1, "", methodObject ),
                    new Among ( "buru", -1, 2, "", methodObject ),
                    new Among ( "duru", -1, 1, "", methodObject ),
                    new Among ( "tsu", -1, 1, "", methodObject ),
                    new Among ( "tu", -1, 1, "", methodObject ),
                    new Among ( "tatu", 282, 4, "", methodObject ),
                    new Among ( "mentu", 282, 1, "", methodObject ),
                    new Among ( "estu", 282, 1, "", methodObject ),
                    new Among ( "txu", -1, 1, "", methodObject ),
                    new Among ( "zu", -1, 1, "", methodObject ),
                    new Among ( "tzu", 287, 1, "", methodObject ),
                    new Among ( "gintzu", 288, 1, "", methodObject ),
                    new Among ( "z", -1, 1, "", methodObject ),
                    new Among ( "ez", 290, 1, "", methodObject ),
                    new Among ( "eroz", 290, 1, "", methodObject ),
                    new Among ( "tz", 290, 1, "", methodObject ),
                    new Among ( "koitz", 293, 1, "", methodObject )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "zlea", -1, 2, "", methodObject ),
                    new Among ( "keria", -1, 1, "", methodObject ),
                    new Among ( "la", -1, 1, "", methodObject ),
                    new Among ( "era", -1, 1, "", methodObject ),
                    new Among ( "dade", -1, 1, "", methodObject ),
                    new Among ( "tade", -1, 1, "", methodObject ),
                    new Among ( "date", -1, 1, "", methodObject ),
                    new Among ( "tate", -1, 1, "", methodObject ),
                    new Among ( "gi", -1, 1, "", methodObject ),
                    new Among ( "ki", -1, 1, "", methodObject ),
                    new Among ( "ik", -1, 1, "", methodObject ),
                    new Among ( "lanik", 10, 1, "", methodObject ),
                    new Among ( "rik", 10, 1, "", methodObject ),
                    new Among ( "larik", 12, 1, "", methodObject ),
                    new Among ( "ztik", 10, 1, "", methodObject ),
                    new Among ( "go", -1, 1, "", methodObject ),
                    new Among ( "ro", -1, 1, "", methodObject ),
                    new Among ( "ero", 16, 1, "", methodObject ),
                    new Among ( "to", -1, 1, "", methodObject )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16 };

        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(BasqueStemmer other)
        {
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_6;
            int v_8;
            // (, line 25
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 31
            v_1 = m_cursor;

            do
            {
                // (, line 31
                // or, line 33

                do
                {
                    v_2 = m_cursor;

                    do
                    {
                        // (, line 32
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab2;
                        }
                        // or, line 32

                        do
                        {
                            v_3 = m_cursor;

                            do
                            {
                                // (, line 32
                                if (!(OutGrouping(g_v, 97, 117)))
                                {
                                    goto lab4;
                                }
                                // gopast, line 32

                                while (true)
                                {

                                    do
                                    {
                                        if (!(InGrouping(g_v, 97, 117)))
                                        {
                                            goto lab6;
                                        }
                                        goto golab5;
                                    } while (false);
                                    lab6:
                                    if (m_cursor >= m_limit)
                                    {
                                        goto lab4;
                                    }
                                    m_cursor++;
                                }
                                golab5:
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = v_3;
                            // (, line 32
                            if (!(InGrouping(g_v, 97, 117)))
                            {
                                goto lab2;
                            }
                            // gopast, line 32

                            while (true)
                            {

                                do
                                {
                                    if (!(OutGrouping(g_v, 97, 117)))
                                    {
                                        goto lab8;
                                    }
                                    goto golab7;
                                } while (false);
                                lab8:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor++;
                            }
                            golab7:;
                        } while (false);
                        lab3:
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 34
                    if (!(OutGrouping(g_v, 97, 117)))
                    {
                        goto lab0;
                    }
                    // or, line 34

                    do
                    {
                        v_6 = m_cursor;

                        do
                        {
                            // (, line 34
                            if (!(OutGrouping(g_v, 97, 117)))
                            {
                                goto lab10;
                            }
                            // gopast, line 34

                            while (true)
                            {

                                do
                                {
                                    if (!(InGrouping(g_v, 97, 117)))
                                    {
                                        goto lab12;
                                    }
                                    goto golab11;
                                } while (false);
                                lab12:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab10;
                                }
                                m_cursor++;
                            }
                            golab11:
                            goto lab9;
                        } while (false);
                        lab10:
                        m_cursor = v_6;
                        // (, line 34
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab0;
                        }
                        // next, line 34
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    } while (false);
                    lab9:;
                } while (false);
                lab1:
                // setmark pV, line 35
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 37
            v_8 = m_cursor;

            do
            {
                // (, line 37
                // gopast, line 38

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab15;
                        }
                        goto golab14;
                    } while (false);
                    lab15:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab14:
                // gopast, line 38

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 117)))
                        {
                            goto lab17;
                        }
                        goto golab16;
                    } while (false);
                    lab17:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab16:
                // setmark p1, line 38
                I_p1 = m_cursor;
                // gopast, line 39

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 117)))
                        {
                            goto lab19;
                        }
                        goto golab18;
                    } while (false);
                    lab19:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab18:
                // gopast, line 39

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 117)))
                        {
                            goto lab21;
                        }
                        goto golab20;
                    } while (false);
                    lab21:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab20:
                // setmark p2, line 39
                I_p2 = m_cursor;
            } while (false);
            lab13:
            m_cursor = v_8;
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_aditzak()
        {
            int among_var;
            // (, line 49
            // [, line 50
            m_ket = m_cursor;
            // substring, line 50
            among_var = FindAmongB(a_0, 109);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 50
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 61
                    // call RV, line 61
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 61
                    SliceDel();
                    break;
                case 2:
                    // (, line 63
                    // call R2, line 63
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 63
                    SliceDel();
                    break;
                case 3:
                    // (, line 65
                    // <-, line 65
                    SliceFrom("atseden");
                    break;
                case 4:
                    // (, line 67
                    // <-, line 67
                    SliceFrom("arabera");
                    break;
                case 5:
                    // (, line 69
                    // <-, line 69
                    SliceFrom("baditu");
                    break;
            }
            return true;
        }

        private bool r_izenak()
        {
            int among_var;
            // (, line 74
            // [, line 75
            m_ket = m_cursor;
            // substring, line 75
            among_var = FindAmongB(a_1, 295);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 75
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 105
                    // call RV, line 105
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 105
                    SliceDel();
                    break;
                case 2:
                    // (, line 107
                    // call R2, line 107
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 107
                    SliceDel();
                    break;
                case 3:
                    // (, line 109
                    // <-, line 109
                    SliceFrom("jok");
                    break;
                case 4:
                    // (, line 111
                    // call R1, line 111
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 111
                    SliceDel();
                    break;
                case 5:
                    // (, line 113
                    // <-, line 113
                    SliceFrom("tra");
                    break;
                case 6:
                    // (, line 115
                    // <-, line 115
                    SliceFrom("minutu");
                    break;
                case 7:
                    // (, line 117
                    // <-, line 117
                    SliceFrom("zehar");
                    break;
                case 8:
                    // (, line 119
                    // <-, line 119
                    SliceFrom("geldi");
                    break;
                case 9:
                    // (, line 121
                    // <-, line 121
                    SliceFrom("igaro");
                    break;
                case 10:
                    // (, line 123
                    // <-, line 123
                    SliceFrom("aurka");
                    break;
            }
            return true;
        }

        private bool r_adjetiboak()
        {
            int among_var;
            // (, line 127
            // [, line 128
            m_ket = m_cursor;
            // substring, line 128
            among_var = FindAmongB(a_2, 19);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 128
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 131
                    // call RV, line 131
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 131
                    SliceDel();
                    break;
                case 2:
                    // (, line 133
                    // <-, line 133
                    SliceFrom("z");
                    break;
            }
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 139
            // do, line 140
            v_1 = m_cursor;

            do
            {
                // call mark_regions, line 140
                if (!r_mark_regions())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // backwards, line 141
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 141
            // repeat, line 142

            while (true)
            {
                v_2 = m_limit - m_cursor;

                do
                {
                    // call aditzak, line 142
                    if (!r_aditzak())
                    {
                        goto lab2;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab1;

                    goto end_of_outer_loop;

                } while (false);
                lab2:
                m_cursor = m_limit - v_2;
                goto replab1;
                end_of_outer_loop: { }
            }
            replab1:
            // repeat, line 143

            while (true)
            {
                v_3 = m_limit - m_cursor;

                do
                {
                    // call izenak, line 143
                    if (!r_izenak())
                    {
                        goto lab4;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab3;

                    goto end_of_outer_loop_2;

                } while (false);
                lab4:
                m_cursor = m_limit - v_3;
                goto replab3;
                end_of_outer_loop_2: { }
            }
            replab3:
            // do, line 144
            v_4 = m_limit - m_cursor;

            do
            {
                // call adjetiboak, line 144
                if (!r_adjetiboak())
                {
                    goto lab5;
                }
            } while (false);
            lab5:
            m_cursor = m_limit - v_4;
            m_cursor = m_limit_backward; return true;
        }


        public override bool Equals(object o)
        {
            return o is BasqueStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}
