/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LoggingEventWrapper {
    private final LoggingEvent loggingEvent;
    private static final int DEFAULT_HEIGHT = -1;
    private Color colorRuleBackground = ChainsawConstants.COLOR_DEFAULT_BACKGROUND;
    private Color colorRuleForeground = ChainsawConstants.COLOR_DEFAULT_FOREGROUND;
    private int markerHeight = -1;
    private int msgHeight = -1;
    private int id;
    private boolean searchMatch = false;
    Map eventMatches = new HashMap();
    private LoggingEventWrapper syncWrapper;
    private boolean displayed;

    public LoggingEventWrapper(LoggingEvent loggingEvent) {
        this.loggingEvent = loggingEvent;
    }

    public LoggingEventWrapper(LoggingEventWrapper loggingEventWrapper) {
        this.loggingEvent = loggingEventWrapper.getLoggingEvent();
        this.id = loggingEventWrapper.id;
        this.syncWrapper = loggingEventWrapper;
        loggingEventWrapper.syncWrapper = this;
    }

    public LoggingEvent getLoggingEvent() {
        return this.loggingEvent;
    }

    public void setProperty(String propName, String propValue) {
        this.loggingEvent.setProperty(propName, propValue);
        if (this.id == 0 && propName.equals("log4jid")) {
            this.id = Integer.parseInt(propValue);
        }
        if (this.syncWrapper != null && !propName.equals("millisdelta")) {
            this.syncWrapper.getLoggingEvent().setProperty(propName, propValue);
        }
    }

    public Object removeProperty(String propName) {
        Object result = this.loggingEvent.removeProperty(propName);
        if (this.syncWrapper != null && !propName.equals("millisdelta")) {
            this.syncWrapper.getLoggingEvent().removeProperty(propName);
        }
        return result;
    }

    public Set getPropertyKeySet() {
        return this.loggingEvent.getPropertyKeySet();
    }

    public void updateColorRuleColors(Color backgroundColor, Color foregroundColor) {
        if (backgroundColor != null && foregroundColor != null) {
            this.colorRuleBackground = backgroundColor;
            this.colorRuleForeground = foregroundColor;
            if (this.syncWrapper != null) {
                this.syncWrapper.colorRuleBackground = this.colorRuleBackground;
                this.syncWrapper.colorRuleForeground = this.colorRuleForeground;
            }
        } else {
            this.colorRuleBackground = ChainsawConstants.COLOR_DEFAULT_BACKGROUND;
            this.colorRuleForeground = ChainsawConstants.COLOR_DEFAULT_FOREGROUND;
            if (this.syncWrapper != null) {
                this.syncWrapper.colorRuleBackground = this.colorRuleBackground;
                this.syncWrapper.colorRuleForeground = this.colorRuleForeground;
            }
        }
    }

    public void evaluateSearchRule(Rule searchRule) {
        this.eventMatches.clear();
        this.searchMatch = searchRule != null && searchRule.evaluate(this.loggingEvent, this.eventMatches);
    }

    public Map getSearchMatches() {
        return this.eventMatches;
    }

    public Color getForeground() {
        return this.colorRuleForeground;
    }

    public Color getBackground() {
        return this.colorRuleBackground;
    }

    public Color getColorRuleBackground() {
        return this.colorRuleBackground;
    }

    public Color getColorRuleForeground() {
        return this.colorRuleForeground;
    }

    public boolean isSearchMatch() {
        return this.searchMatch;
    }

    public void setMarkerHeight(int markerHeight) {
        this.markerHeight = markerHeight;
    }

    public int getMarkerHeight() {
        return this.markerHeight;
    }

    public void setMsgHeight(int msgHeight) {
        this.msgHeight = msgHeight;
    }

    public int getMsgHeight() {
        return this.msgHeight;
    }

    public void setDisplayed(boolean b) {
        this.markerHeight = -1;
        this.msgHeight = -1;
        this.displayed = b;
    }

    public void setPreviousDisplayedEventTimestamp(long previousDisplayedEventTimeStamp) {
        this.setProperty("millisdelta", String.valueOf(this.loggingEvent.getTimeStamp() - previousDisplayedEventTimeStamp));
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingEventWrapper that = (LoggingEventWrapper)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "LoggingEventWrapper - id: " + this.id + " background: " + this.getBackground() + ", foreground: " + this.getForeground() + ", msg: " + this.loggingEvent.getMessage();
    }
}

