/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import org.apache.linkis.configuration.entity.DepartmentTenantVo;
import org.apache.linkis.configuration.entity.TenantVo;
import org.apache.linkis.configuration.service.TenantConfigService;
import org.apache.linkis.configuration.service.TenantService;
import org.apache.linkis.governance.common.protocol.conf.DepartTenantRequest;
import org.apache.linkis.governance.common.protocol.conf.DepartTenantResponse;
import org.apache.linkis.governance.common.protocol.conf.TenantRequest;
import org.apache.linkis.governance.common.protocol.conf.TenantResponse;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantServiceImpl
implements TenantService {
    private static final Logger logger = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    private TenantConfigService tenantConfigService;

    @Override
    @Receiver
    public TenantResponse getTenantData(TenantRequest request, Sender sender) {
        TenantVo tenantVo = this.tenantConfigService.queryTenant(request.user(), request.creator());
        if (null == tenantVo) {
            logger.warn("TenantCache user {} creator {} data loading failed", (Object)request.user(), (Object)request.creator());
            return new TenantResponse(request.user(), request.creator(), "Y", "");
        }
        return new TenantResponse(tenantVo.getUser(), tenantVo.getCreator(), tenantVo.getIsValid(), tenantVo.getTenantValue());
    }

    @Override
    @Receiver
    public DepartTenantResponse getDepartTenantData(DepartTenantRequest departTenantRequest, Sender sender) {
        DepartmentTenantVo departmentTenantVo = this.tenantConfigService.queryDepartTenant(departTenantRequest.creator(), departTenantRequest.departmentId());
        if (null == departmentTenantVo) {
            logger.warn("DepartTenant data loading failed creator {} department {},departTenant cache will set ''  ", (Object)departTenantRequest.creator(), (Object)departTenantRequest.departmentId());
            return new DepartTenantResponse(departTenantRequest.creator(), departTenantRequest.departmentId(), "Y", "");
        }
        return new DepartTenantResponse(departmentTenantVo.getCreator(), departmentTenantVo.getDepartmentId(), departmentTenantVo.getIsValid(), departmentTenantVo.getTenantValue());
    }
}

