/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.server.utils.LinkisMainHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisBaseServerApp {
    private static final Logger logger = LoggerFactory.getLogger(LinkisBaseServerApp.class);

    public static void main(String[] args) throws ReflectiveOperationException {
        String userName = Utils.getJvmUser();
        String hostName = Utils.getComputerName();
        System.setProperty("hostName", hostName);
        System.setProperty("userName", userName);
        String serviceName = System.getProperty(LinkisMainHelper.SERVER_NAME_KEY());
        System.setProperty("spring.application.name", serviceName);
        LinkisMainHelper.formatPropertyFiles(serviceName);
        Object[] allArgs = (String[])ArrayUtils.addAll((Object[])args, (Object[])LinkisMainHelper.getExtraSpringOptions("linkis"));
        String argsString = StringUtils.join((Object[])allArgs, (String)"\n");
        String startLog = String.format("Ready to start %s with args: %s.", serviceName, argsString);
        logger.info(startLog);
        DataWorkCloudApplication.main((String[])allArgs);
    }
}

