/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.ParameterExpression;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

public class SqlSourceBuilder
extends BaseBuilder {
    private static final String PARAMETER_PROPERTIES = "javaType,jdbcType,mode,numericScale,resultMap,typeHandler,jdbcTypeName";

    public SqlSourceBuilder(Configuration configuration) {
        super(configuration);
    }

    public SqlSource parse(String originalSql, Class<?> parameterType, Map<String, Object> additionalParameters) {
        ParameterMappingTokenHandler handler = new ParameterMappingTokenHandler(this.configuration, parameterType, additionalParameters);
        GenericTokenParser parser = new GenericTokenParser("#{", "}", handler);
        String sql = this.configuration.isShrinkWhitespacesInSql() ? parser.parse(SqlSourceBuilder.removeExtraWhitespaces(originalSql)) : parser.parse(originalSql);
        return new StaticSqlSource(this.configuration, sql, handler.getParameterMappings());
    }

    public static String removeExtraWhitespaces(String original) {
        StringTokenizer tokenizer = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        boolean hasMoreTokens = tokenizer.hasMoreTokens();
        while (hasMoreTokens) {
            builder.append(tokenizer.nextToken());
            hasMoreTokens = tokenizer.hasMoreTokens();
            if (!hasMoreTokens) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    private static class ParameterMappingTokenHandler
    extends BaseBuilder
    implements TokenHandler {
        private List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        private Class<?> parameterType;
        private MetaObject metaParameters;

        public ParameterMappingTokenHandler(Configuration configuration, Class<?> parameterType, Map<String, Object> additionalParameters) {
            super(configuration);
            this.parameterType = parameterType;
            this.metaParameters = configuration.newMetaObject(additionalParameters);
        }

        public List<ParameterMapping> getParameterMappings() {
            return this.parameterMappings;
        }

        @Override
        public String handleToken(String content) {
            this.parameterMappings.add(this.buildParameterMapping(content));
            return "?";
        }

        private ParameterMapping buildParameterMapping(String content) {
            MetaClass metaClass;
            Map<String, String> propertiesMap = this.parseParameterMapping(content);
            String property = propertiesMap.get("property");
            Class<Object> propertyType = this.metaParameters.hasGetter(property) ? this.metaParameters.getGetterType(property) : (this.typeHandlerRegistry.hasTypeHandler(this.parameterType) ? this.parameterType : (JdbcType.CURSOR.name().equals(propertiesMap.get("jdbcType")) ? ResultSet.class : (property == null || Map.class.isAssignableFrom(this.parameterType) ? Object.class : ((metaClass = MetaClass.forClass(this.parameterType, this.configuration.getReflectorFactory())).hasGetter(property) ? metaClass.getGetterType(property) : Object.class))));
            ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, propertyType);
            Class<Object> javaType = propertyType;
            String typeHandlerAlias = null;
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if ("javaType".equals(name)) {
                    javaType = this.resolveClass(value);
                    builder.javaType(javaType);
                    continue;
                }
                if ("jdbcType".equals(name)) {
                    builder.jdbcType(this.resolveJdbcType(value));
                    continue;
                }
                if ("mode".equals(name)) {
                    builder.mode(this.resolveParameterMode(value));
                    continue;
                }
                if ("numericScale".equals(name)) {
                    builder.numericScale(Integer.valueOf(value));
                    continue;
                }
                if ("resultMap".equals(name)) {
                    builder.resultMapId(value);
                    continue;
                }
                if ("typeHandler".equals(name)) {
                    typeHandlerAlias = value;
                    continue;
                }
                if ("jdbcTypeName".equals(name)) {
                    builder.jdbcTypeName(value);
                    continue;
                }
                if ("property".equals(name)) continue;
                if ("expression".equals(name)) {
                    throw new BuilderException("Expression based parameters are not supported yet");
                }
                throw new BuilderException("An invalid property '" + name + "' was found in mapping #{" + content + "}.  Valid properties are " + SqlSourceBuilder.PARAMETER_PROPERTIES);
            }
            if (typeHandlerAlias != null) {
                builder.typeHandler(this.resolveTypeHandler(javaType, typeHandlerAlias));
            }
            return builder.build();
        }

        private Map<String, String> parseParameterMapping(String content) {
            try {
                return new ParameterExpression(content);
            }
            catch (BuilderException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BuilderException("Parsing error was found in mapping #{" + content + "}.  Check syntax #{property|(expression), var1=value1, var2=value2, ...} ", ex);
            }
        }
    }
}

