/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder.factory;

import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.builder.LabelBuilder;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.StdLabelBuilderFactory;
import org.apache.linkis.manager.label.conf.LabelCommonConfig;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelBuilderFactoryContext {
    private static final Logger logger = LoggerFactory.getLogger(LabelBuilderFactoryContext.class);
    private static Class<? extends LabelBuilderFactory> clazz = StdLabelBuilderFactory.class;
    private static LabelBuilderFactory labelBuilderFactory = null;

    public static void register(Class<? extends LabelBuilderFactory> clazz) {
        LabelBuilderFactoryContext.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabelBuilderFactory getLabelBuilderFactory() {
        if (labelBuilderFactory != null) return labelBuilderFactory;
        Class<LabelBuilderFactoryContext> clazz = LabelBuilderFactoryContext.class;
        synchronized (LabelBuilderFactoryContext.class) {
            if (labelBuilderFactory != null) return labelBuilderFactory;
            String className = (String)LabelCommonConfig.LABEL_FACTORY_CLASS.acquireNew();
            if (LabelBuilderFactoryContext.clazz == StdLabelBuilderFactory.class && StringUtils.isNotBlank((CharSequence)className)) {
                try {
                    LabelBuilderFactoryContext.clazz = ClassUtils.getClass((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("find class + " + className + " failed!", e);
                }
            }
            try {
                labelBuilderFactory = LabelBuilderFactoryContext.clazz.newInstance();
                LabelBuilderFactoryContext.labelBuilderInitRegister(labelBuilderFactory);
            }
            catch (Throwable e) {
                throw new RuntimeException("initial class + " + className + " failed!", e);
            }
            return labelBuilderFactory;
        }
    }

    private static void labelBuilderInitRegister(LabelBuilderFactory labelBuilderFactory) {
        Reflections reflections = org.apache.linkis.common.utils.ClassUtils.reflections();
        Set allLabelBuilderClass = reflections.getSubTypesOf(LabelBuilder.class);
        if (null != allLabelBuilderClass) {
            for (Class next : allLabelBuilderClass) {
                try {
                    labelBuilderFactory.registerLabelBuilder((LabelBuilder)next.newInstance());
                    logger.info("Succeed  to register label builder: " + next.getName());
                }
                catch (Throwable e) {
                    logger.error("Failed to register label builder: " + next.getName(), e);
                }
            }
        }
    }
}

