/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import springfox.documentation.service.VendorExtension;

public class ObjectVendorExtension
implements VendorExtension<List<VendorExtension>> {
    private final List<VendorExtension> properties = new ArrayList<VendorExtension>();
    private final String name;

    public ObjectVendorExtension(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<VendorExtension> getValue() {
        return Collections.unmodifiableList(this.properties);
    }

    public void addProperty(VendorExtension property) {
        this.properties.add(property);
    }

    public void replaceProperty(VendorExtension property) {
        Optional<VendorExtension> vendorProperty = StreamSupport.stream(this.properties.spliterator(), false).filter(this.withName(property.getName())).findFirst();
        vendorProperty.ifPresent(this.properties::remove);
        this.properties.add(property);
    }

    private Predicate<VendorExtension> withName(String name) {
        return input -> input.getName().equals(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectVendorExtension that = (ObjectVendorExtension)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "properties=" + this.properties + ", " + "name=" + this.name + "}";
    }
}

