/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionByValue;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLSubPartitionByRange;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByValue;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.dialect.starrocks.ast.StarRocksIndexDefinition;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.StringUtils;
import java.util.LinkedList;
import java.util.List;

public class StarRocksCreateTableParser
extends SQLCreateTableParser {
    public StarRocksCreateTableParser(Lexer lexer) {
        super(new StarRocksExprParser(lexer));
    }

    public StarRocksCreateTableParser(String sql) {
        super(new StarRocksExprParser(sql));
    }

    public StarRocksCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public StarRocksExprParser getExprParser() {
        return (StarRocksExprParser)this.exprParser;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        StarRocksCreateTableStatement createTable = this.newCreateStatement();
        createTable.setDbType(this.getDbType());
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            createTable.setExternal(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimension(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token = this.lexer.token();
                if (this.lexer.identifierEquals(FnvHash.Constants.SUPPLEMENTAL) && DbType.oracle == this.dbType) {
                    SQLTableElement element = this.parseCreateTableSupplementalLogingProps();
                    element.setParent(createTable);
                    createTable.getTableElementList().add(element);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn(createTable);
                    column.setParent(createTable);
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    if (this.lexer.token() == Token.INDEX) {
                        StarRocksIndexDefinition index = new StarRocksIndexDefinition();
                        this.lexer.nextToken();
                        index.setIndexName(this.exprParser.name());
                        this.accept(Token.LPAREN);
                        while (true) {
                            index.getColumns().add(this.exprParser.name());
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        if (this.lexer.token() == Token.USING) {
                            this.lexer.nextToken();
                            this.accept(Token.BITMAP);
                            index.setUsingBitmap(true);
                        }
                        if (this.lexer.token() == Token.COMMENT) {
                            this.lexer.nextToken();
                            index.setComment(StringUtils.removeNameQuotes(this.lexer.stringVal()));
                            this.lexer.nextToken();
                        }
                        index.setParent(createTable);
                        createTable.getTableElementList().add(index);
                    } else {
                        column = this.exprParser.parseColumn();
                        createTable.getTableElementList().add(column);
                    }
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = null;
            select = DbType.oracle == this.dbType ? new OracleSelectParser(this.exprParser).select() : this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        if (this.lexer.token() == Token.WITH && DbType.postgresql == this.dbType) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(createTable.getTableOptions(), createTable, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            createTable.setTablespace(this.exprParser.name());
        }
        if (this.lexer.token() == Token.PARTITION) {
            SQLPartitionBy partitionClause = this.parsePartitionBy();
            createTable.setPartitioning(partitionClause);
        }
        this.parseCreateTableRest(createTable);
        return createTable;
    }

    @Override
    public void parseCreateTableRest(SQLCreateTableStatement stmt) {
        StarRocksCreateTableStatement srStmt = (StarRocksCreateTableStatement)stmt;
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            stmt.setEngine(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DUPLICATE) || this.lexer.identifierEquals(FnvHash.Constants.AGGREGATE) || this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.PRIMARY) {
            SQLName model = this.exprParser.name();
            this.accept(Token.KEY);
            SQLIndexDefinition modelKey = new SQLIndexDefinition();
            modelKey.setType(model.getSimpleName());
            modelKey.setKey(true);
            srStmt.setModelKey(modelKey);
            this.exprParser.parseIndexRest(modelKey, srStmt);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            srStmt.setComment(new SQLCharExpr(StringUtils.removeNameQuotes(this.lexer.stringVal())));
            this.accept(this.lexer.token());
        }
        if (this.lexer.token() == Token.PARTITION) {
            SQLPartitionBy clause = this.parsePartitionBy();
            srStmt.setPartitioning(clause);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLExpr hash = this.exprParser.expr();
            srStmt.setDistributedBy(hash);
            if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                this.lexer.nextToken();
                int bucket = this.lexer.integerValue().intValue();
                stmt.setBuckets(bucket);
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.ORDER) {
            this.parseOrderBy(stmt);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            srStmt.getStarRocksProperties().addAll(this.parseProperties(srStmt));
        }
    }

    @Override
    public SQLPartitionBy parsePartitionBy() {
        SQLPartitionBy partitionClause;
        SQLPartitionBy clause;
        this.lexer.nextToken();
        this.accept(Token.BY);
        boolean linera = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.LINEAR)) {
            this.lexer.nextToken();
            linera = true;
        }
        if (this.lexer.token() == Token.KEY) {
            clause = new MySqlPartitionByKey();
            this.lexer.nextToken();
            if (linera) {
                clause.setLinear(true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
                this.lexer.nextToken();
                this.accept(Token.EQ);
                ((MySqlPartitionByKey)clause).setAlgorithm(this.lexer.integerValue().shortValue());
                this.lexer.nextToken();
            }
            this.accept(Token.LPAREN);
            if (this.lexer.token() != Token.RPAREN) {
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            this.accept(Token.RPAREN);
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals("HASH") || this.lexer.identifierEquals("UNI_HASH")) {
            clause = new SQLPartitionByHash();
            if (this.lexer.identifierEquals("UNI_HASH")) {
                ((SQLPartitionByHash)clause).setUnique(true);
            }
            this.lexer.nextToken();
            if (linera) {
                clause.setLinear(true);
            }
            if (this.lexer.token() == Token.KEY) {
                this.lexer.nextToken();
                ((SQLPartitionByHash)clause).setKey(true);
            }
            this.accept(Token.LPAREN);
            this.exprParser.exprList(clause.getColumns(), clause);
            this.accept(Token.RPAREN);
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals("RANGE")) {
            partitionClause = clause = this.partitionByRange();
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals("VALUE")) {
            partitionClause = clause = this.partitionByValue();
            this.partitionClauseRest(clause);
        } else if (this.lexer.identifierEquals("LIST")) {
            this.lexer.nextToken();
            clause = new SQLPartitionByList();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier("COLUMNS");
                this.accept(Token.LPAREN);
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            partitionClause = clause;
            this.partitionClauseRest(clause);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            partitionClause = clause = this.partitionByRange();
            this.partitionClauseRest(clause);
        } else {
            throw new ParserException("TODO. " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
            this.lexer.nextToken();
            partitionClause.setLifecycle((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLPartition partitionDef = this.getExprParser().parsePartition();
                partitionClause.addPartition(partitionDef);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partitionClause;
    }

    protected void partitionClauseRest(SQLPartitionBy clause) {
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS) || this.lexer.identifierEquals(FnvHash.Constants.TBPARTITIONS) || this.lexer.identifierEquals(FnvHash.Constants.DBPARTITIONS)) {
            this.lexer.nextToken();
            SQLIntegerExpr countExpr = this.exprParser.integerExpr();
            clause.setPartitionsCount(countExpr);
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("NUM")) {
                this.lexer.nextToken();
            }
            clause.setPartitionsCount(this.exprParser.expr());
            clause.putAttribute("ads.partition", Boolean.TRUE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
            this.lexer.nextToken();
            clause.setLifecycle((SQLIntegerExpr)this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLSubPartitionBy subPartitionByClause = null;
            boolean linear = false;
            if (this.lexer.identifierEquals("LINEAR")) {
                this.lexer.nextToken();
                linear = true;
            }
            if (this.lexer.token() == Token.KEY) {
                MySqlSubPartitionByKey subPartitionKey = new MySqlSubPartitionByKey();
                this.lexer.nextToken();
                if (linear) {
                    clause.setLinear(true);
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    subPartitionKey.setAlgorithm(this.lexer.integerValue().shortValue());
                    this.lexer.nextToken();
                }
                this.accept(Token.LPAREN);
                while (true) {
                    subPartitionKey.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionKey;
            } else if (this.lexer.identifierEquals("VALUE")) {
                MySqlSubPartitionByValue subPartitionByValue = new MySqlSubPartitionByValue();
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    subPartitionByValue.addColumn(this.exprParser.expr());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionByValue;
            } else if (this.lexer.identifierEquals("HASH")) {
                this.lexer.nextToken();
                SQLSubPartitionByHash subPartitionHash = new SQLSubPartitionByHash();
                if (linear) {
                    clause.setLinear(true);
                }
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    subPartitionHash.setKey(true);
                }
                this.accept(Token.LPAREN);
                subPartitionHash.setExpr(this.exprParser.expr());
                this.accept(Token.RPAREN);
                subPartitionByClause = subPartitionHash;
            } else if (this.lexer.identifierEquals("LIST")) {
                SQLExpr expr;
                this.lexer.nextToken();
                MySqlSubPartitionByList subPartitionList = new MySqlSubPartitionByList();
                if (this.lexer.token() == Token.KEY) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    while (true) {
                        if ((expr = this.exprParser.expr()) instanceof SQLIdentifierExpr && (this.lexer.identifierEquals("bigint") || this.lexer.identifierEquals("long"))) {
                            String dataType = this.lexer.stringVal();
                            this.lexer.nextToken();
                            SQLColumnDefinition column = this.exprParser.createColumnDefinition();
                            column.setName((SQLIdentifierExpr)expr);
                            column.setDataType(new SQLDataTypeImpl(dataType));
                            subPartitionList.addColumn(column);
                            subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                        }
                        subPartitionList.addKey(expr);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                    this.accept(Token.RPAREN);
                } else if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LITERAL_ALIAS) {
                        expr = new SQLIdentifierExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                    } else {
                        expr = this.exprParser.expr();
                    }
                    if (expr instanceof SQLIdentifierExpr && (this.lexer.identifierEquals("bigint") || this.lexer.identifierEquals("long"))) {
                        String dataType = this.lexer.stringVal();
                        this.lexer.nextToken();
                        SQLColumnDefinition column = this.exprParser.createColumnDefinition();
                        column.setName((SQLIdentifierExpr)expr);
                        column.setDataType(new SQLDataTypeImpl(dataType));
                        subPartitionList.addColumn(column);
                        subPartitionList.putAttribute("ads.subPartitionList", Boolean.TRUE);
                    } else {
                        subPartitionList.addKey(expr);
                    }
                    this.accept(Token.RPAREN);
                } else {
                    this.acceptIdentifier("COLUMNS");
                    this.accept(Token.LPAREN);
                    while (true) {
                        subPartitionList.addColumn(this.exprParser.parseColumn());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                subPartitionByClause = subPartitionList;
            } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                this.lexer.nextToken();
                SQLSubPartitionByRange range = new SQLSubPartitionByRange();
                this.accept(Token.LPAREN);
                this.exprParser.exprList(range.getColumns(), range);
                this.accept(Token.RPAREN);
                subPartitionByClause = range;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTIONS");
                this.exprParser.parseAssignItem(subPartitionByClause.getOptions(), (SQLObject)subPartitionByClause);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITIONS)) {
                this.lexer.nextToken();
                Number intValue = this.lexer.integerValue();
                SQLNumberExpr numExpr = new SQLNumberExpr(intValue);
                subPartitionByClause.setSubPartitionsCount(numExpr);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                subPartitionByClause.setSubPartitionsCount((SQLIntegerExpr)this.exprParser.expr());
                subPartitionByClause.getAttributes().put("adb.partitons", true);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                subPartitionByClause.setLifecycle((SQLIntegerExpr)this.exprParser.expr());
            }
            if (subPartitionByClause != null) {
                subPartitionByClause.setLinear(linear);
                clause.setSubPartitionBy(subPartitionByClause);
            }
        }
    }

    protected SQLPartitionByRange partitionByRange() {
        SQLPartitionByRange clause = new SQLPartitionByRange();
        if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            } else {
                this.acceptIdentifier("COLUMNS");
                this.accept(Token.LPAREN);
                while (true) {
                    clause.addColumn(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
        } else {
            SQLExpr expr = this.exprParser.expr();
            if (this.lexer.identifierEquals(FnvHash.Constants.STARTWITH)) {
                this.lexer.nextToken();
                SQLExpr start = this.exprParser.primary();
                this.acceptIdentifier("ENDWITH");
                SQLExpr end = this.exprParser.primary();
                expr = new SQLBetweenExpr(expr, start, end);
            }
            clause.setInterval(expr);
        }
        return clause;
    }

    protected SQLPartitionByValue partitionByValue() {
        SQLPartitionByValue clause = new SQLPartitionByValue();
        if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                clause.addColumn(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
        }
        return clause;
    }

    @Override
    protected StarRocksCreateTableStatement newCreateStatement() {
        return new StarRocksCreateTableStatement();
    }

    public List<SQLExpr> parseProperties(SQLObject parent) {
        LinkedList<SQLExpr> starRocksProperties = new LinkedList<SQLExpr>();
        do {
            if (this.lexer.token() == Token.LBRACKET) {
                this.accept(Token.LBRACKET);
                SQLArrayExpr arrayExpr = new SQLArrayExpr();
                arrayExpr.setParent(parent);
                arrayExpr.getValues().add(this.exprParser.parseAssignItem(true, (SQLObject)arrayExpr));
                starRocksProperties.add(arrayExpr);
                if (this.lexer.token() == Token.COMMA) {
                    this.accept(Token.COMMA);
                }
                this.accept(Token.RBRACKET);
            } else {
                starRocksProperties.add(this.exprParser.parseAssignItem(true, parent));
            }
            if (this.lexer.token() != Token.COMMA) continue;
            this.accept(Token.COMMA);
        } while (this.lexer.token() != Token.RPAREN);
        this.accept(Token.RPAREN);
        return starRocksProperties;
    }

    private void parseOrderBy(SQLCreateTableStatement stmt) {
        this.lexer.nextToken();
        this.accept(Token.BY);
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.addSortedByItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
    }
}

